// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ReturnStatementNode.cs,v 1.3 2007-12-27 08:34:39 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// returñm[h\NXłB
	/// </summary>
	public class ReturnStatementNode : Node
	{
		/// <summary>
		/// ̃m[h
		/// </summary>
		private Node expNode;

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			if(! context.MoveNext())
				throw new ParseException("';' expected", this.ContextToken);
			ContextToken ct = (ContextToken)context.Current;
			string token = ct.ToString();
			if(token == ";")
				return;
			expNode = new ExpressionNode();
			expNode.Parse(context);
			ct = (ContextToken)context.Current;
			token = ct.ToString();
			if(token != ";")
				throw new ParseException("';' expected", this.ContextToken);
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			if(expNode != null)
				expNode = expNode.Simplify();
			return this;
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <exception cref="Protra.Lib.Lang.ReturnStatementExecutedException">
		/// ɖ߂lvZꂽꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			Value val = null;
			if(expNode != null)
				val = expNode.Execute(resource, at);
			throw new ReturnStatementExecutedException(val);
		}
	}

	/// <summary>
	/// ReturnStatementNode.ExecuteĂ΂ꂽƂthrowOłB
	/// </summary>
	public class ReturnStatementExecutedException : Exception
	{
		/// <summary>
		/// ߂ll
		/// </summary>
		private Value val;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">߂ll</param>
		public ReturnStatementExecutedException(Value val)
		{
			this.val = val;
		}

		/// <summary>
		/// ߂ll擾܂B
		/// </summary>
		public Value Value
		{
			get { return val; }
		}
	}
}
