﻿// Copyright(C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: PrimaryNode.cs 430 2011-10-19 06:31:33Z darai $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// 一次子のノードを表すクラス。
	/// </summary>
	public class PrimaryNode : Node
	{
		/// <summary>
		/// 構文解析する。
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// 構文解析中にエラーが発生したときにthrowされる。
		/// </exception>
        /// <return>
        /// 解析した結果のノード。
        /// </return>
		public override Node Parse()
		{
			Token = Scanner.Token;

			if (Token.Type == TokenType.LocalVariable ||
                Token.Type == TokenType.GlobalVariable)
				return new VariableNode().Parse();

			if (Token.Type == TokenType.Int ||
                Token.Type == TokenType.Float ||
                Token.Type == TokenType.String ||
                Token.Value == "null")
				return new LiteralNode().Parse();

			if (Token.Type == TokenType.FunctionName)
				return new FunctionNode().Parse();

            if (Token.Value == "[")
                return new ArrayNode().Parse();

            if (Token.Value == "(")
            {
                Scanner.Scan();
                Node node = new ExpressionNode().Parse();
                if (Scanner.Token.Value != ")")
                    throw new ParseException("')' expected", Token);
                Scanner.Scan();
                return node;
            }
			throw new ParseException("syntax error", Token);
		}

		/// <summary>
		/// プログラムを実行する。
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// プログラム実行中にエラーが発生した場合にthrowされる。
		/// </exception>
		/// <param name="resource">リソース</param>
		/// <param name="at">int型@作用素の値</param>
		/// <param name="ats">string型@作用素の値</param>
		/// <returns>実行結果</returns>
		public override Value Execute(Resource resource, int at, string ats)
		{
			return null;
		}
	}
}
