// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: BasicBuiltins.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using Protra.Lib.Db;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// {Iȑgݍ݊֐sNXBsɕKvȃReLXgێB
    /// </summary>
    public class BasicBuiltins : MathBuiltins
    {
        private Price[] prices;
        private int index;
        private int rightIndex;

        /// <summary>
        /// sΏۂ̉if[^擾܂͐ݒ肷B
        /// </summary>
        public Price[] Prices {
            set { prices = value; }
            get { return prices; }
        }

        /// <summary>
        /// sΏۂ̖擾B
        /// </summary>
        public Brand Brand {
            get { return prices[0].Brand; }
        }

        /// <summary>
        /// CfbNXݒ܂͎擾B
        /// </summary>
        public int Index {
            set { index = value; }
            get { return index; }
        }

        /// <summary>
        /// E[̃CfbNXݒ肷B
        /// </summary>
        public int RightIndex
        {
            set { rightIndex = value; }
        }

        /// <summary>
        /// gݍ݊֐sB
        /// </summary>
        /// <param name="name">O</param>
        /// <param name="args"></param>
        /// <param name="at">atp[^</param>
        /// <returns></returns>
        public override Value Invoke(string name, Value[] args, int at)
        {
            if (args.Length != 0)
                return base.Invoke(name, args, at);
            try
            {
                switch (name)
                {
                case "Index":
                    return new Value(index + at);
                case "RightIndex":
                    return new Value(rightIndex);
                case "Year":
                    return new Value(prices[index + at].Date.Year);
                case "Month":
                    return new Value(prices[index + at].Date.Month);
                case "Day":
                    return new Value(prices[index + at].Date.Day);
                case "DayOfWeek":
                    return new Value((int)prices[index + at].Date.DayOfWeek);
                case "Open":
                    return new Value(prices[index + at].Open);
                case "High":
                    return new Value(prices[index + at].High);
                case "Low":
                    return new Value(prices[index + at].Low);
                case "Close":
                    return new Value(prices[index + at].Close);
                case "Volume":
                    return new Value(prices[index + at].Volume);
                case "Code":
                    return new Value(Brand.Code);
                }
            }
            catch(IndexOutOfRangeException)
            {
                return null;
            }
            return base.Invoke(name, args, at);
        }
    }
}
