﻿// Copyright (C) 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: BrandListConfig.cs 301 2010-03-18 08:03:41Z panacoran $

using System.Collections.Generic;
using System.IO;

namespace Protra.Lib.Config
{
    /// <summary>
    /// 銘柄リストを格納するクラス。
    /// </summary>
    public class BrandList
    {
        /// <summary>
        /// 銘柄リストの名前を取得または設定する。
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 銘柄リストを取得または設定する。
        /// </summary>
        public List<string> List { get; set; }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public BrandList()
        {
            List = new List<string>();
        }

        /// <summary>
        /// 文字列形式を返す。
        /// </summary>
        /// <returns>銘柄リストの名前。</returns>
        public override string ToString()
        {
            return Name;
        }
    }

    /// <summary>
    /// 銘柄リストの設定を読み書きするクラス。
    /// </summary>
    public class BrandListConfig : ConfigBase
    {
        /// <summary>
        /// 銘柄リストリストを取得する。
        /// </summary>
        public List<BrandList> List { get; set; }

        /// <summary>
        /// 設定ファイルの名前を取得する。
        /// </summary>
        protected override string ConfigName
        {
            get { return "brandlist"; }
        }



        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public BrandListConfig() : base(true)
        {
            List = new List<BrandList>();
        }

        void watcher_Changed(object sender, FileSystemEventArgs e)
        {
            Load();
        }

        /// <summary>
        /// 古い設定ファイルを読み込む。
        /// </summary>
        protected override void ReadOldConfig()
        {
            ConfigFile configFile = new ConfigFile("ptenv");
            BrandList favorite = new BrandList();
            favorite.List = new List<string>();
            favorite.Name = "お気に入り";
            try
            {
                configFile.Read();
                for (int i = 0; ; i++)
                {
                    string val = configFile["FavoriteBrandId" + i.ToString()];
                    if (val == null)
                        break;
                    Db.Brand brand = Db.BrandTable.GetRecord(int.Parse(val));
                    favorite.List.Add(brand.NewId);
                }
                
            }
            catch
            {}
            List.Add(favorite);
            
            foreach (Db.BrandList brandList in Db.BrandListTable.GetAllRecords())
            {
                BrandList bl = new BrandList();
                bl.Name = brandList.Name;
                foreach (Db.Brand brand in brandList.Brands)
                    bl.List.Add(brand.NewId);
                List.Add(bl);
            }
        }
    }
}