/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.jdt.hover;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.resources.Messages;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.util.PropertiesFileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class PropertiesHover
implements IJavaEditorTextHover {
    private IEditorPart editorPart;

    public void setEditor(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        int endIdx;
        int startIdx;
        block11: {
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            try {
                int lineNum = document.getLineOfOffset(offset);
                int lineOffset = document.getLineOffset(lineNum);
                int lineLength = document.getLineLength(lineNum);
                String source = document.get();
                startIdx = -1;
                int tmp = offset - 1;
                while (tmp >= lineOffset) {
                    if ((tmp = source.lastIndexOf("\"", tmp)) < lineOffset) {
                        startIdx = -1;
                        break;
                    }
                    if (tmp > 0) {
                        if (document.getChar(tmp - 1) == '\\') continue;
                        startIdx = tmp + 1;
                        break;
                    }
                    if (tmp == 0) {
                        startIdx = 1;
                        break;
                    }
                    startIdx = -1;
                    break;
                }
                tmp = offset + 1;
                endIdx = -1;
                while (tmp < lineOffset + lineLength) {
                    if ((tmp = source.indexOf("\"", tmp)) > lineOffset + lineLength) {
                        endIdx = -1;
                        break;
                    }
                    if (tmp > 0) {
                        if (document.getChar(tmp - 1) == '\\') continue;
                        endIdx = tmp;
                        break;
                    }
                    if (tmp == 0) {
                        endIdx = 0;
                        break;
                    }
                    endIdx = -1;
                }
                if (startIdx != -1 && endIdx != -1 && startIdx != endIdx) break block11;
                return null;
            }
            catch (BadLocationException e) {
                Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                ILog log = PropertiesEditorPlugin.getDefault().getLog();
                log.log((IStatus)status);
                return null;
            }
        }
        String key = textViewer.getDocument().get(startIdx, endIdx - startIdx);
        return this.getPropertyValue(key);
    }

    private String getPropertyValue(String targetKey) {
        if (targetKey == null || targetKey.equals("")) {
            return "";
        }
        IEditorInput editorInput = this.editorPart.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fEditorInput = (IFileEditorInput)editorInput;
            IProject project = fEditorInput.getFile().getProject();
            IJavaProject jProject = JavaCore.create((IProject)project);
            IPath outputPath = null;
            try {
                outputPath = jProject.getOutputLocation();
            }
            catch (JavaModelException e) {
                Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                ILog log = PropertiesEditorPlugin.getDefault().getLog();
                log.log((IStatus)status);
            }
            IFile[] pFiles = PropertiesFileUtil.findFileExt((IContainer)project, outputPath, "properties");
            Properties list = new Properties();
            int i = 0;
            while (i < pFiles.length) {
                ILog log;
                Status status;
                Properties prop = new Properties();
                try {
                    prop.load(pFiles[i].getContents());
                }
                catch (IOException e) {
                    status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                    log = PropertiesEditorPlugin.getDefault().getLog();
                    log.log((IStatus)status);
                }
                catch (CoreException e) {
                    status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                    log = PropertiesEditorPlugin.getDefault().getLog();
                    log.log((IStatus)status);
                }
                if (prop.containsKey(targetKey)) {
                    list.put(pFiles[i].getFullPath().toPortableString(), prop.getProperty(targetKey));
                }
                ++i;
            }
            if (list.isEmpty()) {
                return null;
            }
            Enumeration<Object> enu = list.keys();
            StringBuffer buf = new StringBuffer();
            buf.append("&lt;").append(Messages.getString("eclipse.propertieseditor.hover.key")).append(":").append(targetKey).append("&gt;<br/>");
            while (enu.hasMoreElements()) {
                String path = (String)enu.nextElement();
                String value = (String)list.get(path);
                value = value.replaceAll("\r\n", "<br/>");
                value = value.replaceAll("\n", "<br/>");
                value = value.replaceAll("\r", "<br/>");
                buf.append("&lt;").append(Messages.getString("eclipse.propertieseditor.hover.file")).append(":").append(path).append("&gt;<br/>");
                buf.append(value);
                buf.append("<br/>");
            }
            return buf.toString();
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return null;
    }
}

