/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.Exceptions;
import java.io.IOException;
import java.nio.CharBuffer;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String makeSafe(String string) {
        return string == null ? "" : string;
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        return new ArrayList(initialArraySize);
    }

    public static <E> ArrayList<E> newArrayList(Collection<? extends E> collection) {
        return new ArrayList<E>(collection);
    }

    public static <E> ArrayList<E> newArrayList(E ... es) {
        return new ArrayList<E>(Arrays.asList(es));
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <E extends Comparable<?>> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        TreeSet<Comparable> set = new TreeSet<Comparable>();
        if (elements instanceof Collection) {
            set.addAll((Collection)elements);
        } else {
            for (Comparable e : elements) {
                set.add(e);
            }
        }
        return set;
    }

    public static <E extends Comparable<?>> HashSet<E> newHashSet(E ... es) {
        return new HashSet<E>(Arrays.asList(es));
    }

    public static String join(String separator, Iterable<?> parts) {
        try {
            return Util.appendTo(new StringBuilder(), separator, parts).toString();
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static void checkArgument(boolean expression, String fieldName, Object value) throws SQLException {
        if (!expression) {
            throw Exceptions.newInvalidParameterException(fieldName, value);
        }
    }

    public static void checkParameter(boolean expression, String message, Object ... arguments) throws SQLException {
        if (!expression) {
            throw Exceptions.newInvalidParameterException(MessageFormat.format(message, arguments));
        }
    }

    private static <A extends Appendable> A appendTo(A appendable, String separator, Iterable<?> parts) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable can not be null");
        }
        Iterator<?> iterator = parts.iterator();
        if (iterator.hasNext()) {
            appendable.append(String.valueOf(iterator.next()));
            while (iterator.hasNext()) {
                appendable.append(separator);
                appendable.append(String.valueOf(iterator.next()));
            }
        }
        return appendable;
    }

    public static String toIntegerList(int[] ints) {
        if (ints != null && ints.length > 0) {
            ArrayList<String> typeStringList = Util.newArrayList();
            for (int type : ints) {
                typeStringList.add(Integer.toString(type));
            }
            return Util.join(",", typeStringList);
        }
        return null;
    }

    public static char[] extractChars(CharBuffer buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return buf.array();
        }
        char[] result = new char[buf.remaining()];
        buf.get(result);
        buf.position(buf.position() - result.length);
        return result;
    }
}

