/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.File;
import java.io.IOException;
import org.slim3.gen.desc.ClassDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.message.MessageFormatter;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.task.AbstractGenFileTask;
import org.slim3.gen.task.JavaFile;

public abstract class AbstractGenJavaFileTask
extends AbstractGenFileTask {
    protected File srcDir;
    protected File testDir;

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setTestDir(File testDir) {
        this.testDir = testDir;
    }

    protected void doExecute() throws Exception {
        super.doExecute();
        if (this.srcDir == null) {
            throw new IllegalStateException("The srcDir parameter is null.");
        }
        if (this.testDir == null) {
            throw new IllegalStateException("The testDir parameter is null.");
        }
    }

    protected JavaFile createJavaFile(ClassDesc classDesc) {
        return new JavaFile(this.srcDir, classDesc);
    }

    protected JavaFile createTestCaseJavaFile(ClassDesc classDesc) {
        return new JavaFile(this.testDir, classDesc, "Test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateJavaFile(Generator generator, JavaFile javaFile) throws IOException {
        File file = javaFile.getFile();
        String className = javaFile.getClassName();
        if (file.exists()) {
            this.log(MessageFormatter.getSimpleMessage(MessageCode.SLIM3GEN0004, className));
            return;
        }
        Printer printer = null;
        try {
            printer = this.createPrinter(file);
            generator.generate(printer);
        }
        finally {
            if (printer != null) {
                printer.close();
            }
        }
        this.log(MessageFormatter.getSimpleMessage(MessageCode.SLIM3GEN0005, className));
    }
}

