<?php
// {{{ StrSjis

/**
 * SJIŜ߂̃NXBX^eBbN\bhŗpB
 * SJIS̖Ă̂CJbgB
 *
 * @author aki
 * @since  2006/10/02
 * @static
 */
class StrSjis
{
    // {{{ note

    /**
     * Qlf[^
     * SJIS 2oCg̑1oCg͈ 129`159A224`239i0x81`0x9FA0xE0`0xEFj
     * SJIS 2oCg̑2oCg͈ 64`126A128`252i0x40`0x7EA0x80`0xFCji1oCg͈͂Ăj
     * SJIS p(ASCII) 33`126i0x21`0x7Ej 32 
     * SJIS pJi161`223i0xA1`0xDFj(2oCg̈)
     */

    /*
    // SJISȎ1oCgőł邩ǂ̖ڎpeXgR[h
    // ł邪Ẫ݂`FbNł͕sB擪珇2oCg̑g𒲂ׂKvcB
    for ($i = 0; $i <= 255; $i++) {
        if (self::isSjis1stByte($i)) {
            for ($j = 0; $j <= 255; $j++) {
                if (self::isSjisCrasherCode($j)) {
                    echo $i . ' '. pack('C*', $i) . pack('C*', $j) . "<br><br>";
                }
            }
        }
    }
    */

    // }}}
    // {{{ fixSjis()

    /**
     * SJIS̖AoCgł΁A^OvƂȂ̂ŃJbgB
     *
     * @access  public
     * @return  string
     */
    static public function fixSjis($str)
    {
        if (strlen($str) == 0) {
            return;
        }

        $un = unpack('C*', $str);

        $on_sjisfirst = false;
        $on_crasher = false;
        foreach ($un as $v) {
            if ($on_sjisfirst) {
                $on_sjisfirst = false;
                $on_crasher = false;
            } else {
                if (self::isSjis1stByte($v)) {
                    $on_sjisfirst = true;
                    $on_crasher = true;
                } elseif (self::isSjisCrasherCode($v)) {
                    $on_crasher = true;
                }
            }
        }

        if ($on_crasher) {
            $str = substr($str, 0, -1);
        }
        return $str;

        /*
        // ݂̂`FbN邽߂̃R[hBł͕sB
        if (self::isSjisCrasherCode($un[$count]) && !self::isSjis1stByte($un[$count-1])) {
            $str = substr($str, 0, -1);
            return $str;
        }
        */
    }

    // }}}
    // {{{ isSjisCrasherCode()

    /**
     * SJISŖɂƁiJn^OƂāj\̂R[h͈̔́i10ij
     * 1oCg͈͂łȂ2oCg͈͂łR[h͂
     * 129-159 224-252 iڎŒׂj
     * ڎpeXgR[h
     * for ($i = 0; $i <= 255; $i++) {
     *    echo $i . ': '. pack('C*', $i) . "<br><br>";
     * }
     * iQl SJIS 2oCgR[h͈͂̂1oCgR[hɓĂ͂܂Ȃ̂ 128-160 224-252j
     *
     * @return  boolean  R[hԍ͈͂ł true Ԃ
     */
    static public function isSjisCrasherCode($int)
    {
        if (129 <= $int && $int <= 159 or 224 <= $int && $int <= 252) {
            return true;
        }
        return false;
    }

    // }}}
    // {{{ isSjis1stByte()

    /**
     * SJIS 2oCg̑1oCg͈͂ǂ𒲂ׂ 129`159A224`239i0x81`0x9FA0xE0`0xEFj
     *
     * @return  boolean  R[hԍ1oCg͈͂ł true Ԃ
     */
    static public function isSjis1stByte($int)
    {
        if (129 <= $int && $int <= 159 or 224 <= $int && $int <= 239) {
            return true;
        }
        return false;
    }

    // }}}
    // {{{ getUnicodePattern()

    /**
     * Shift_JIS̕܂ސK\p^[
     * PCREUnicode[hpK\p^[ɕϊ
     *
     * @param   string  $pattern
     * @return  string
     */
    static public function toUnicodePattern($pattern)
    {
        $sjis_char_class_1st = '[\\x81-\\x9F\\xE0-\\xFC]';
        $sjis_char_class_2nd = '[\\x40-\\x7E\\x80-\\xFC]';
        $sjis_char_regex_1st = '\\\\x(8[1-9A-F]|[9E][0-9A-F]|F[0-9A-C])';
        $sjis_char_regex_2nd = '\\\\x([45689A-E][0-9A-F]|7[0-9A-E]|F[0-9A-C])';

        $pattern = preg_replace_callback("/{$sjis_char_class_1st}{$sjis_char_class_2nd}/",
                                         array(__CLASS__, '_sjisStringToUnicodePatternCb'),
                                         $pattern);
        $pattern = preg_replace_callback("/{$sjis_char_regex_1st}{$sjis_char_regex_2nd}/i",
                                         array(__CLASS__, '_sjisPatternToUnicodePatternCb'),
                                         $pattern);
        return $pattern;
    }

    // }}}
    // {{{ _sjisStringToUnicodePattern()

    /**
     * Shift_JIS2oCg
     * UnicodeɃ}b`鐳K\p^[ɕϊ
     *
     * @param   array   $m
     * @return  string
     */
    static protected function _sjisStringToUnicodePatternCb($m)
    {
        $u = unpack('C2', mb_convert_encoding($m[0], 'UCS-2BE', 'SJIS-win'));
        return sprintf('\\x{%02X%02X}', $u[1], $u[2]);
    }

    // }}}
    // {{{ _sjisCodeToUnicodePattern()

    /**
     * Shift_JIS2oCgɃ}b`鐳K\p^[
     * UnicodeɃ}b`鐳K\p^[ɕϊ
     *
     * @param   array   $m
     * @return  string
     */
    static protected function _sjisPatternToUnicodePatternCb($m)
    {
        $s = pack('C2', hexdec($m[1]), hexdec($m[2]));
        return self::_sjisStringToUnicodePatternCb(array($s));
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
