<?php

// {{{ BrdCtl

/**
 * rep2 - BrdCtl -- XgRg[NX for menu.php
 *
 * @static
 */
class BrdCtl
{
    // {{{ read_brds()

    /**
     * boardSēǂݍ
     */
    static public function read_brds()
    {
        $brd_menus_dir = BrdCtl::read_brd_dir();
        $brd_menus_online = BrdCtl::read_brd_online();
        $brd_menus = array_merge($brd_menus_dir, $brd_menus_online);
        return $brd_menus;
    }

    // }}}
    // {{{ read_brd_dir()

    /**
     * boardfBNg𑖍ēǂݍ
     */
    static public function read_brd_dir()
    {
        $brd_menus = array();
        $brd_dir = './board';

        if ($cdir = @dir($brd_dir)) {
            // fBNg
            while ($entry = $cdir->read()) {
                if ($entry[0] == '.') {
                    continue;
                }
                $filepath = $brd_dir.'/'.$entry;
                if ($data = FileCtl::file_read_lines($filepath)) {
                    $aBrdMenu = new BrdMenu();    // NX BrdMenu ̃IuWFNg𐶐
                    $aBrdMenu->setBrdMatch($filepath);    // p^[}b``o^
                    $aBrdMenu->setBrdList($data);    // JeS[ƔZbg
                    $brd_menus[] = $aBrdMenu;

                } else {
                    P2Util::pushInfoHtml("<p>p2 error: Xg {$entry} ǂݍ߂܂łB</p>");
                }
            }
            $cdir->close();
        }

        return $brd_menus;
    }

    // }}}
    // {{{ read_brd_online()

    /**
    * ICXgǍ
    */
    static public function read_brd_online()
    {
        global $_conf;

        $brd_menus = array();
        $isNewDL = false;

        if ($_conf['brdfile_online']) {
            $cachefile = P2Util::cacheFileForDL($_conf['brdfile_online']);
            $noDL = false;
            $read_html_flag = false;

            // LbVꍇ
            if (file_exists($cachefile.'.p2.brd')) {
                // norefreshȂDLȂ
                if (!empty($_GET['nr'])) {
                    $noDL = true;
                // LbV̍XVw莞ԈȓȂDLȂ
                } elseif (@filemtime($cachefile.'.p2.brd') > time() - 60 * 60 * $_conf['menu_dl_interval']) {
                    $noDL = true;
                }
            }

            // DLȂ
            if ($noDL) {
                ;
            // DL
            } else {
                //echo "DL!<br>";//
                $brdfile_online_res = P2Util::fileDownload($_conf['brdfile_online'], $cachefile);
                if ($brdfile_online_res->isSuccess() && $brdfile_online_res->code != 304) {
                    $isNewDL = true;
                }
            }

            // html`Ȃ
            if (preg_match('/html?$/', $_conf['brdfile_online'])) {

                // XVĂVKLbV쐬
                if ($isNewDL) {
                    // ʂLbV̂
                    if (isset($GLOBALS['word']) && strlen($GLOBALS['word']) > 0) {
                        $_tmp = array($GLOBALS['word'], $GLOBALS['word_fm'], $GLOBALS['words_fm']);
                        $GLOBALS['word'] = null;
                        $GLOBALS['word_fm'] = null;
                        $GLOBALS['words_fm'] = null;
                    } else {
                        $_tmp = null;
                    }

                    //echo "NEW!<br>"; //
                    $aBrdMenu = new BrdMenu(); // NX BrdMenu ̃IuWFNg𐶐
                    $aBrdMenu->makeBrdFile($cachefile); // .p2.brdt@C𐶐
                    $brd_menus[] = $aBrdMenu;
                    unset($aBrdMenu);

                    if ($_tmp) {
                        list($GLOBALS['word'], $GLOBALS['word_fm'], $GLOBALS['words_fm']) = $_tmp;
                        $brd_menus = array();
                    } else {
                        $read_html_flag = true;
                    }
                }

                if (file_exists($cachefile.'.p2.brd')) {
                    $cache_brd = $cachefile.'.p2.brd';
                } else {
                    $cache_brd = $cachefile;
                }

            } else {
                $cache_brd = $cachefile;
            }

            if (!$read_html_flag) {
                if ($data = FileCtl::file_read_lines($cache_brd)) {
                    $aBrdMenu = new BrdMenu(); // NX BrdMenu ̃IuWFNg𐶐
                    $aBrdMenu->setBrdMatch($cache_brd); // p^[}b``o^
                    $aBrdMenu->setBrdList($data); // JeS[ƔZbg
                    if ($aBrdMenu->num) {
                        $brd_menus[] = $aBrdMenu;
                    } else {
                        P2Util::pushInfoHtml("<p>p2 error: {$cache_brd} j[𐶐邱Ƃ͂ł܂łB</p>");
                    }
                    unset($data, $aBrdMenu);
                } else {
                    P2Util::pushInfoHtml("<p>p2 error: {$cachefile} ͓ǂݍ߂܂łB</p>");
                }
            }
        }

        return $brd_menus;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
