<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=4 fdm=marker: */
/* mi: charset=Shift_JIS */

require_once 'Pager/Pager.php';

class Google_Renderer
{
    // {{{ properties

    /**
     * ʃubN̊Jn^O
     *
     * @var string
     * @access private
     */
    var $opener = '<table cellspacing="0" width="100%">';

    /**
     * ʁEwb_
     *
     * @var string
     * @access private
     */
    var $header = '<tr class="tableheader">
    <td class="t%s"></td>
    <td class="t%s">^Cg</td>
    <td class="t%s">͈</td>
    <td class="t%s"></td>
</tr>';

    /**
     * ʁEeACe
     *
     * @var string
     * @access private
     */
    var $body = '<tr>
    <td class="t%s">%s</td>
    <td class="t%s">%s</td>
    <td class="tn%s">%s</td>
    <td class="t%s">%s</td>
</tr>';

    /**
     * ʁEG[
     *
     * @var string
     * @access private
     */
    var $error = '<tr><td colspan="4" align="center">%s</td></tr>';

    /**
     * ʁEtb^
     *
     * @var string
     * @access private
     */
    var $footer = '<tr class="tableheader">
    <td class="t%s" colspan="4" align="center">%d-%d / %d hits.</td>
</tr>';

    /**
     * ʃubN̏I^O
     *
     * @var string
     * @access private
     */
    var $closer = '</table>';

    // }}}
    // {{{ getRowClass()

    /**
     * ss̎ʎqԂ
     */
    function getRowClass()
    {
        static $i = 0;
        $i++;
        return ($i % 2 == 1) ? '' : '2';
    }

    // }}}
    // {{{ printSearchResult()

    /**
     * ʂo͂
     *
     * @return void
     * @access public
     */
    function printSearchResult(&$result, $word, $perPage, $start, $totalItems)
    {
        echo $this->opener;
        $this->printSearchResultHeader($this->getRowClass());
        if (is_array($result) && count($result) > 0) {
            foreach ($result as $id => $val) {
                $this->printSearchResultBody($id, $val, $this->getRowClass());
            }
        } elseif (is_string($result) && strlen($result) > 0) {
            printf($this->error, $result);
        }
        $this->printSearchResultFooter($perPage, $start, $totalItems, $this->getRowClass());
        echo $this->closer;
    }

    // }}}
    // {{{ printSearchResultHeader()

    /**
     * ʂ̃wb_o͂
     *
     * @return void
     * @access public
     */
    function printSearchResultHeader($rc)
    {
        printf($this->header, $rc, $rc, $rc, $rc);
    }

    // }}}
    // {{{ printSearchResultBody()

    /**
     * ʂ̖{̂o͂
     *
     * @return void
     * @access public
     */
    function printSearchResultBody($id, $val, $rc)
    {
        $eh = "onmouseover=\"gShowPopUp('s%s',event)\" onmouseout=\"gHidePopUp('s%s')\"";
        $title = "<a class=\"thre_title\" href=\"%s\" {$eh} target=\"%s\" >%s</a>";

        $type_col  = $val['type'];
        $title_col = sprintf($title, $val['url'], $id, $id, $val['target'], $val['title']);
        $range_col = ($val['ls']  !== '') ? $val['ls']  : '&nbsp;';
        $ita_col   = ($val['ita'] !== '') ? $val['ita'] : '&nbsp;';

        printf($this->body, $rc, $type_col, $rc, $title_col, $rc, $range_col, $rc, $ita_col);
    }

    // }}}
    // {{{ printSearchResultFooter()

    /**
     * ʂ̃tb^o͂
     *
     * @return void
     * @access public
     */
    function printSearchResultFooter($perPage, $start, $totalItems, $rc)
    {
        $from = ($totalItems > 0) ? ($start + 1) : 0;
        $to   = min($start + $perPage, $totalItems);

        printf($this->footer, $rc, $from, $to, $totalItems);
    }

    // }}}
    // {{{ printPopup()

    /**
     * |bvAbvpBvfo͂
     *
     * @return void
     * @access public
     */
    function printPopup(&$popups)
    {
        if (!is_array($popups) || count($popups) == 0) {
            return;
        }

        $eh = "onmouseover=\"gShowPopUp('s%s',event)\" onmouseout=\"gHidePopUp('s%s')\"";
        $popup = "<div id=\"s%s\" class=\"respopup\" {$eh}>%s</div>\n";

        foreach ($popups as $id => $content) {
            printf($popup, $id, $id, $id, $content);
        }
    }

    // }}}
    // {{{ printPager()

    /**
     * y[WړpNo͂
     *
     * @return void
     * @access public
     */
    function printPager($perPage, $totalItems)
    {
        if (FALSE !== ($pager = &$this->makePager($perPage, $totalItems))) {
            echo '<table id="sbtoolbar2" class="toolbar" cellspacing="0"><tr><td align="center">';
            echo $pager->links;
            echo '</td></tr></table>';
        }
    }

    // }}}
    // {{{ makePager()

    /**
     * ʓł̃y[WړpPEAR::Pager̃CX^X쐬
     *
     * @return object
     * @access public
     */
    function &makePager($perPage, $totalItems)
    {
        if ($totalItems == 0 || $totalItems <= $perPage) {
            $retval = FALSE;
            return $retval;
        }

        $pagerOptions = array(
            'mode'       => 'Sliding',
            'totalItems' => $totalItems,
            'perPage'    => $perPage,
            'delta'      => 5, // qbgy[WÕNy[W
            'urlVar'     => 'p', // y[WID肷GET/POST̕ϐAftHg"PageID"
            'spacesBeforeSeparator' => 1,
            'spacesAfterSeparator'  => 1,
        );

        $pager = &Pager::factory($pagerOptions);

        return $pager;
    }

    // }}}
    // {{{ _rawurlencode_cb()

    /**
     * array_walk_recursive()̃R[obN\bhƂĎgp
     *
     * @return void
     * @access public
     */
    function _rawurlencode_cb(&$value, $key)
    {
        $value = rawurlencode($value);
    }

    // }}}
}

?>
