<?php

/*
define(P2_SUBJECT_TXT_STORAGE, 'eashm');    // veAccelerator

[dl] shmƒLbVȂ
[dl] shmmodifiedȂ

shmɂĂptH[}X͂قƂǕςȂi悤j
*/

/**
 * SubjectTxtNX
 */
class SubjectTxt{

    var $host;
    var $bbs;
    var $subject_url;
    var $subject_file;
    var $subject_lines;
    var $storage; // file, eashm(eAccelerator shm) // 2006/02/27 aki eashm ͔񐄏

    /**
     * RXgN^
     */
    function SubjectTxt($host, $bbs)
    {
        $this->host = $host;
        $this->bbs =  $bbs;
        if (defined('P2_SUBJECT_TXT_STORAGE') && P2_SUBJECT_TXT_STORAGE == 'eashm') {
            $this->storage = P2_SUBJECT_TXT_STORAGE;
        } else {
            $this->storage = 'file';
        }

        $this->subject_file = P2Util::datDirOfHost($this->host) . '/' . $this->bbs . '/subject.txt';

        $this->subject_url = "http://" . $this->host . '/' . $this->bbs . "/subject.txt";

        // ΂livedoorړ]ɑΉBǍlivedoorƂB
        $this->subject_url = P2Util::adjustHostJbbs($this->subject_url);

        // subject.txt_E[hZbg
        $this->dlAndSetSubject();
    }

    /**
     * subject.txt_E[hZbg
     *
     * @return boolean Zbgł trueAłȂ false
     */
    function dlAndSetSubject()
    {
        if ($this->storage == 'eashm') {
            $cont = eaccelerator_get("$this->host/$this->bbs");
        } else {
            $cont = '';
        }
        if (!$cont || !empty($_POST['newthread'])) {
            $cont = $this->downloadSubject();
        }
        if ($this->setSubjectLines($cont)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * subject.txt_E[h
     *
     * @return string subject.txt ̒g
     */
    function downloadSubject()
    {
        global $_conf, $_info_msg_ht;

        $perm = (isset($_conf['dl_perm'])) ? $_conf['dl_perm'] : 0606;

        if ($this->storage == 'file') {
            FileCtl::mkdir_for($this->subject_file); // fBNg΍

            if (file_exists($this->subject_file)) {
                if (!empty($_GET['norefresh']) || isset($_REQUEST['word'])) {
                    return;    // XVȂꍇ́ȀŔĂ܂
                } elseif (empty($_POST['newthread']) and $this->isSubjectTxtFresh()) {
                    return;    // VKXĎłȂAXVVꍇ
                }
                $modified = gmdate("D, d M Y H:i:s", filemtime($this->subject_file))." GMT";
            } else {
                $modified = false;
            }
        }

        // DL
        include_once "HTTP/Request.php";

        $params = array();
        $params['timeout'] = $_conf['fsockopen_time_limit'];
        if ($_conf['proxy_use']) {
            $params['proxy_host'] = $_conf['proxy_host'];
            $params['proxy_port'] = $_conf['proxy_port'];
        }
        $req =& new HTTP_Request($this->subject_url, $params);
        $modified && $req->addHeader("If-Modified-Since", $modified);
        $req->addHeader('User-Agent', 'Monazilla/1.00 (' . $_conf['p2name'] . '/' . $_conf['p2version'] . ')');

        $response = $req->sendRequest();

        if (PEAR::isError($response)) {
            $error_msg = $response->getMessage();
        } else {
            $code = $req->getResponseCode();
            if ($code == 302) {
                // zXg̈ړ]ǐ
                include_once P2_LIBRARY_DIR . '/BbsMap.class.php';
                $new_host = BbsMap::getCurrentHost($this->host, $this->bbs);
                if ($new_host != $this->host) {
                    $aNewSubjectTxt = &new SubjectTxt($new_host, $this->bbs);
                    $body = $aNewSubjectTxt->downloadSubject();
                    return $body;
                }
            }
            if (!($code == 200 || $code == 206 || $code == 304)) {
                //var_dump($req->getResponseHeader());
                $error_msg = $code;
            }
        }

        if (isset($error_msg) && strlen($error_msg) > 0) {
            $url_t = P2Util::throughIme($this->subject_url);
            $_info_msg_ht .= "<div>Error: {$error_msg}<br>";
            $_info_msg_ht .= "p2 info: <a href=\"{$url_t}\"{$_conf['ext_win_target_at']}>{$this->subject_url}</a> ɐڑł܂łB</div>";
            $body = '';
        } else {
            $body = $req->getResponseBody();
        }

        //  DL  XVĂ
        if ($body && $code != "304") {

            //  or be.2ch.net ȂEUCSJISɕϊ
            if (P2Util::isHostJbbsShitaraba($this->host) || P2Util::isHostBe2chNet($this->host)) {
                $body = mb_convert_encoding($body, 'SJIS-win', 'eucJP-win');
            }

            // eashmɕۑꍇ
            if ($this->storage == 'eashm') {
                $eacc_key = "$this->host/$this->bbs";
                eaccelerator_lock($eacc_key);
                //echo $body;
                eaccelerator_put($eacc_key, $body, $_conf['sb_dl_interval']);
                eaccelerator_unlock($eacc_key);

            // t@Cɕۑꍇ
            } else {
                if (FileCtl::file_write_contents($this->subject_file, $body) === false) {
                    die("Error: cannot write file");
                }
                chmod($this->subject_file, $perm);
            }
        } else {
            // touch邱ƂōXVC^[ôŁA΂炭ă`FbNȂȂ
            // iύXȂ̂ɏCԂXV̂́ACi܂ȂAł͓ɖȂ낤j
            if ($this->storage == 'file') {
                touch($this->subject_file);
            }
        }

        return $body;
    }


    /**
     * subject.txt VNȂ true Ԃ
     *
     * @return boolean VNȂ trueBłȂ falseB
     */
    function isSubjectTxtFresh()
    {
        global $_conf;

        // LbVꍇ
        if (file_exists($this->subject_file)) {
            // LbV̍XVw莞ԈȓȂ
            // clearstatcache();
            if (filemtime($this->subject_file) > time() - $_conf['sb_dl_interval']) {
                return true;
            }
        }

        return false;
    }

    /**
     * subject.txt ǂݍ
     *
     * ΁A$this->subject_lines Zbg
     *
     * @param string $cont  eashm pɓnĂB
     * @return boolean s
     */
    function setSubjectLines($cont = '')
    {
        if ($this->storage == 'eashm') {
            if (!$cont) {
                $cont = eaccelerator_get("$this->host/$this->bbs");
            }
            $this->subject_lines = explode("\n", $cont);

        } elseif ($this->storage == 'file') {
            if (extension_loaded('zlib') and strstr($this->host, '.2ch.net')) {
                $this->subject_lines = gzfile($this->subject_file);    // ͂̂O 2005/6/5
            } else {
                $this->subject_lines = file($this->subject_file);
            }
        }

        // JBBS@΂ȂdX^C폜
        if (P2Util::isHostJbbsShitaraba($this->host)) {
            $this->subject_lines = array_unique($this->subject_lines);
        }

        if ($this->subject_lines) {
            return true;
        } else {
            return false;
        }
    }

}

?>
