<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=4 fdm=marker: */
/* mi: charset=Shift_JIS */

require_once P2_LIBRARY_DIR . '/p2util.class.php';
require_once P2_LIBRARY_DIR . '/filectl.class.php';

// {{{ class BbsMap

/**
 * BbsMapNX
 *
 * -zXg̑Ή\쐬AɊÂăzXg̓s
 */
class BbsMap
{
    // {{{ getCurrentHost()

    /**
     * ŐṼzXg擾
     *
     * @param   string  $host   zXg
     * @param   string  $bbs    
     * @param   bool    $autosync   ړ]oƂɎœ邩ۂ
     * @return  string  ɑΉŐṼzXg
     * @access  public
     * @static
     */
    function getCurrentHost($host, $bbs, $autosync = true)
    {
        global $_info_msg_ht;
        static $synced = false;

        // }bsOǂݍ
        $map = BbsMap::_getMapping();
        if (!$map) {
            return $host;
        }
        $type = BbsMap::_detectHostType($host);

        // `FbN
        if (isset($map[$type]) && isset($map[$type][$bbs])) {
            $new_host = $map[$type][$bbs]['host'];
            if ($host != $new_host && $autosync && !$synced) {
                // ړ]o炨CɔACɃXAŋߓǂ񂾃Xœ
                $msg_fmt = '<p>rep2 info: zXg̈ړ]o܂B(%s/%s  %s/%s)<br>';
                $msg_fmt .= 'CɔACɃXAŋߓǂ񂾃Xœ܂B</p>';
                $_info_msg_ht .= sprintf($msg_fmt, $host, $bbs, $new_host, $bbs);
                BbsMap::syncFav();
                $synced = true;
            }
            $host = $new_host;
        }

        return $host;
    }

    // }}}
    // {{{ getBbsName()

    /**
     * LONG擾
     *
     * @param   string  $host   zXg
     * @param   string  $bbs    
     * @return  string  j[ɋLڂĂ
     * @access  public
     * @static
     */
    function getBbsName($host, $bbs)
    {
        // }bsOǂݍ
        $map = BbsMap::_getMapping();
        if (!$map) {
            return $bbs;
        }
        $type = BbsMap::_detectHostType($host);

        // `FbN
        if (isset($map[$type]) && isset($map[$type][$bbs])) {
            $itaj = $map[$type][$bbs]['itaj'];
        } else {
            $itaj = $bbs;
        }

        return $itaj;
    }

    // }}}
    // {{{ syncBrd()

    /**
     * CɔȂǂbrdt@C𓯊
     *
     * @param   string  $brd_path   brdt@C̃pX
     * @return  void
     * @access  public
     * @static
     */
    function syncBrd($brd_path)
    {
        global $_conf, $_info_msg_ht;
        static $done = array();

        // {{{ Ǎ

        if (isset($done[$brd_path])) {
            return;
        }
        $lines = BbsMap::_readData($brd_path);
        if (!$lines) {
            return;
        }
        $map = BbsMap::_getMapping();
        if (!$map) {
            return;
        }
        $neolines = array();
        $updated = false;

        // }}}
        // {{{ 

        foreach ($lines as $line) {
            $setitaj = false;
            $data = explode("\t", rtrim($line, "\n"));
            $hoge = $data[0]; // \?
            $host = $data[1];
            $bbs  = $data[2];
            $itaj = $data[3];
            $type = BbsMap::_detectHostType($host);

            if (isset($map[$type]) && isset($map[$type][$bbs])) {
                $newhost = $map[$type][$bbs]['host'];
                if ($itaj === '') {
                    $itaj = $map[$type][$bbs]['itaj'];
                    if ($itaj != $bbs) {
                        $setitaj = true;
                    } else {
                        $itaj = '';
                    }
                }
            } else {
                $newhost = $host;
            }

            if ($host != $newhost || $setitaj) {
                $neolines[] = "{$hoge}\t{$newhost}\t{$bbs}\t{$itaj}\n";
                $updated = true;
            } else {
                $neolines[] = $line;
            }
        }

        // }}}
        // {{{ 

        if ($updated) {
            BbsMap::_writeData($brd_path, $neolines);
            $_info_msg_ht .= sprintf('<p>rep2 info: %s 𓯊܂B</p>', htmlspecialchars($brd_path, ENT_QUOTES));
        } else {
            $_info_msg_ht .= sprintf('<p>rep2 info: %s ͕ύX܂łB</p>', htmlspecialchars($brd_path, ENT_QUOTES));
        }
        $done[$brd_path] = true;

        // }}}
    }

    // }}}
    // {{{ syncIdx()

    /**
     * CɃXȂǂidxt@C𓯊
     *
     * @param   string  $idx_path   idxt@C̃pX
     * @return  void
     * @access  public
     * @static
     */
    function syncIdx($idx_path)
    {
        global $_conf, $_info_msg_ht;
        static $done = array();

        // {{{ Ǎ

        if (isset($done[$idx_path])) {
            return;
        }
        $lines = BbsMap::_readData($idx_path);
        if (!$lines) {
            return;
        }
        $map = BbsMap::_getMapping();
        if (!$map) {
            return;
        }
        $neolines = array();
        $updated = false;

        // }}}
        // {{{ 

        foreach ($lines as $line) {
            $data = explode('<>', rtrim($line, "\n"));
            $host = $data[10];
            $bbs  = $data[11];
            $type = BbsMap::_detectHostType($host);

            if (isset($map[$type]) && isset($map[$type][$bbs])) {
                $newhost = $map[$type][$bbs]['host'];
            } else {
                $newhost = $host;
            }

            if ($host != $newhost) {
                $data[10] = $newhost;
                $neolines[] = implode('<>', $data) . "\n";
                $updated = true;
            } else {
                $neolines[] = $line;
            }
        }

        // }}}
        // {{{ 

        if ($updated) {
            BbsMap::_writeData($idx_path, $neolines);
            $_info_msg_ht .= sprintf('<p>rep2 info: %s 𓯊܂B</p>', htmlspecialchars($idx_path, ENT_QUOTES));
        } else {
            $_info_msg_ht .= sprintf('<p>rep2 info: %s ͕ύX܂łB</p>', htmlspecialchars($idx_path, ENT_QUOTES));
        }
        $done[$idx_path] = true;

        // }}}
    }

    // }}}
    // {{{ syncFav()

    /**
     * CɔACɃXAŋߓǂ񂾃X𓯊
     *
     * @return  void
     * @access  public
     * @static
     */
    function syncFav()
    {
        global $_conf;
        BbsMap::syncBrd($_conf['favita_path']);
        BbsMap::syncIdx($_conf['favlist_file']);
        BbsMap::syncIdx($_conf['rct_file']);
    }

    // }}}
    // {{{ _getMapping()

    /**
     * 2chj[p[XA-zXg̑Ή\쐬
     *
     * @return  array   site/bbs/(host,itaj) ̑Azz
     *                  _E[hɎsƂ false
     * @access  private
     * @static
     */
    function _getMapping()
    {
        global $_conf, $_info_msg_ht;
        static $map = null;

        // {{{ ݒ

        $bbsmenu_url = 'http://menu.2ch.net/bbsmenu.html';
        $map_cache_path = $_conf['pref_dir'] . '/p2_cache/host_bbs_map.txt';
        $map_cache_lifetime = 600; // TTL͏Z߂
        $errfmt = '<p>rep2 error: BbsMap: %s - %s _E[hł܂łB</p>';

        // }}}
        // {{{ LbVmF

        if (!is_null($map)) {
            return $map;
        } elseif (file_exists($map_cache_path)) {
            $mtime = filemtime($map_cache_path);
            $expires = $mtime + $map_cache_lifetime;
            if (time() < $expires) {
                $map_cahce = file_get_contents($map_cache_path);
                $map = unserialize($map_cahce);
                return $map;
            }
        } else {
            FileCtl::mkdir_for($map_cache_path);
        }
        touch($map_cache_path);
        clearstatcache();

        // }}}
        // {{{ j[_E[h

        $params = array();
        if (isset($mtime)) {
            $params['requestHeaders'] = array('If-Modified-Since' => gmdate('D, d M Y H:i:s', $mtime) . ' GMT');
            $params['timeout'] = $_conf['fsockopen_time_limit'];
            //$params['readTimeout'] = array($_conf['fsockopen_time_limit'], 0);
        }
        $req = &new HTTP_Request($bbsmenu_url, $params);
        $req->setMethod('GET');
        $err = $req->sendRequest(true);

        // G[
        if (PEAR::isError($err)) {
            $_info_msg_ht .= sprintf($errfmt, htmlspecialchars($err->getMessage()), htmlspecialchars($bbsmenu_url, ENT_QUOTES));
            if (file_exists($map_cache_path)) {
                return unserialize(file_get_contents($map_cache_path));
            } else {
                return false;
            }
        }

        // X|XR[h
        $code = $req->getResponseCode();
        if ($code == 304) {
            $map_cahce = file_get_contents($map_cache_path);
            $map = unserialize($map_cahce);
            return $map;
        } elseif ($code != 200) {
            $_info_msg_ht .= sprintf($errfmt, htmlspecialchars(strval($code)), htmlspecialchars($bbsmenu_url, ENT_QUOTES));
            if (file_exists($map_cache_path)) {
                return unserialize(file_get_contents($map_cache_path));
            } else {
                return false;
            }
        }

        $res_body = $req->getResponseBody();

        // }}}
        // {{{ p[X

        $regex = '!<A HREF=http://(\w+\.(?:2ch\.net|bbspink\.com|machi\.to|mathibbs\.com))/(\w+)/(?: TARGET=_blank)?>(.+?)</A>!';
        preg_match_all($regex, $res_body, $matches, PREG_SET_ORDER);

        $map = array();
        foreach ($matches as $match) {
            $host = $match[1];
            $bbs  = $match[2];
            $itaj = $match[3];
            $type = BbsMap::_detectHostType($host);
            if (!isset($map[$type])) {
                $map[$type] = array();
            }
            $map[$type][$bbs] = array('host' => $host, 'itaj' => $itaj);
        }

        // }}}
        // {{{ LbV

        $map_cache = serialize($map);
        if (FileCtl::file_write_contents($map_cache_path, $map_cache) === false) {
            $errmsg = sprintf('Error: cannot write file. (%s)', htmlspecialchars($map_cache_path, ENT_QUOTES));
            die($errmsg);
        }

        // }}}

        return $map;
    }

    // }}}
    // {{{ _readData()

    /**
     * XVÕf[^ǂݍ
     *
     * @param   string  $path   ǂݍރt@C̃pX
     * @return  array   t@C̓eAǂݏoɎsƂ false
     * @access  private
     * @static
     */
    function _readData($path)
    {
        if (!file_exists($path)) {
            return false;
        }

        $lines = file($path);
        if (!$lines) {
            return false;
        }

        return $lines;
    }

    // }}}
    // {{{ _writeData()

    /**
     * XṼf[^
     *
     * @param   string  $path   ރt@C̃pX
     * @param   array   $neolines   ރf[^̔z
     * @return  void
     * @access  private
     * @static
     */
    function _writeData($path, $neolines)
    {
        if (is_array($neolines) && count($neolines) > 0) {
            $cont = implode('', $neolines);
        /*} elseif (is_scalar($neolines)) {
            $cont = strval($neolines);*/
        } else {
            $cont = '';
        }
        if (FileCtl::file_write_contents($path, $cont) === false) {
            $errmsg = sprintf('Error: cannot write file. (%s)', htmlspecialchars($path, ENT_QUOTES));
            die($errmsg);
        }
    }

    // }}}
    // {{{ _detectHostType()

    /**
     * zXg̎ނ𔻒肷
     *
     * @param   string  $host   zXg
     * @return  string  zXg̎
     * @access  private
     * @static
     */
    function _detectHostType($host)
    {
        if (P2Util::isHostBbsPink($host)) {
            $type = 'bbspink';
        } elseif (P2Util::isHost2chs($host)) {
            $type = '2channel';
        } elseif (P2Util::isHostMachiBbs($host)) {
            $type = 'machibbs';
        } elseif (P2Util::isHostJbbsShitaraba($host)) {
            $type = 'jbbs';
        } else {
            $type = $host;
        }
        return $type;
    }

    // }}}
}

// }}}
?>
