#!/usr/bin/env python

import xmlrpclib
import datetime
import sqlite3
import time
import databases
# see http://d.hatena.ne.jp/keyword/%a4%cf%a4%c6%a4%ca%a5%d6%a5%c3%a5%af%a5%de%a1%bc%a5%af%b7%ef%bf%f4%bc%e8%c6%c0API?kid=146686




def hoge():
    DATABASE = "database/story_dat"
    range_begin = datetime.datetime(2010, 4, 26)
    range_end = datetime.datetime(2010, 5, 26)
    begin_t = time.mktime(range_begin.timetuple())
    end_t = time.mktime(range_end.timetuple())

    cmd = """select sid from stories where date >= ? and date < ? and sid in (
                      select sid from topics) order by date
        """
    con = sqlite3.connect(DATABASE)
    cur = con.cursor()
    cur.execute(cmd, (begin_t, end_t))

    urls = []
    counts = {}
    db = databases.HatebuDB()
    with db:
        for row in cur:
            sid = row[0]
            urls.append("http://sourceforge.jp/magazine/" + sid)
            if len(urls) == 50:
                results = get_count(urls)
                urls = []
                for url in results:
                    id = url.replace("http://sourceforge.jp/magazine/", "")
                    count = results[url]
                    db.add(id, count)

        if len(urls) > 0:
            results = get_count(urls)
            urls = []
            for url in results:
                id = url.replace("http://sourceforge.jp/magazine/", "")
                count = results[url]
                db.add(id, count)

def get_count(urls):    
    uri = "http://b.hatena.ne.jp/xmlrpc"
    server = xmlrpclib.ServerProxy(uri)
    t = server.bookmark.getCount(*urls)
    return t


def main():
    hoge()

if __name__ == "__main__":
    main()
