/***********************************************************************//**
	@file
	$Revision: 80 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:08:47 +0900#$
***************************************************************************/
#include <sstream>
#include <boost/bind.hpp>
#include "common/Command.h"
#include "Player.h"
#include "Receiver.h"

namespace openmj {
namespace server {
/***********************************************************************//**
	コンストラクタ
***************************************************************************/
Player::Player(Socket* socket)
    : socket_(socket), 
      serial_(0), 
      thread_(boost::bind(&Player::exec, this)), 
      receiver_(0)
{}
/***********************************************************************//**
	デストラクタ
***************************************************************************/
Player::~Player() {
    fprintf(stderr, "destruct Player\n");
    delete socket_;
}
/***********************************************************************//**
	
***************************************************************************/
void Player::close() {
    socket_->close();
    receiver_ = 0;
}
/***********************************************************************//**
	
***************************************************************************/
void Player::send(const char* command) {
    assert(socket_);
    std::ostringstream buff;
    buff << (++serial_) << " " << command << Socket::EOL;
    socket_->send(buff.str().c_str());
}
/***********************************************************************//**
	レシーバをセットする
	@param	receiver	レシーバ
***************************************************************************/
void Player::recv(Receiver* receiver) {
    if(receiver_) {
        fprintf(stderr, "warning: timeout\n");
    }
    receiver_ = receiver;
}
/***********************************************************************//**
	
***************************************************************************/
void Player::exec() {
    while(socket_->isOpen()) {
        Command command;
        if(socket_->recvCommand(command) && receiver_) {
            receiver_->recv(this, command);
            receiver_ = 0;
        }
    }
    delete this;
}
/***********************************************************************//**
	$Id: Player.cpp 80 2009-03-28 13:08:47Z yatsuhashi $
***************************************************************************/
}	/* namespace server */
}	/* namespace openmj */
