/***********************************************************************//**
	@file
	$Revision: 80 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:08:47 +0900#$
***************************************************************************/
#include <sstream>
#include <boost/bind.hpp>
#include "Game.h"
#include "Player.h"

namespace openmj {
namespace server {
/***********************************************************************//**
	コンストラクタ
	@param	playerMax	プレイヤーの数
***************************************************************************/
Game::Game(int playerMax)
    : playerMax_(playerMax), 
      thread_(0)
{}
/***********************************************************************//**
	デストラクタ
***************************************************************************/
Game::~Game() {
    while(!playerList_.empty()) {
        playerList_.back()->close();
        playerList_.pop_back();
    }
}
/***********************************************************************//**
	プレイヤーを追加する
	@param	player	プレイヤー
	@return		全員揃ったら真
***************************************************************************/
bool Game::appendPlayer(Player* player) {
    playerList_.push_back(player);
    return (playerList_.size() == playerMax_);
}
/***********************************************************************//**
	ゲームを開始する
***************************************************************************/
void Game::start() {
    assert(!thread_);
    thread_ = new boost::thread(boost::bind(&Game::Exec, this));
}
/***********************************************************************//**
	
***************************************************************************/
void Game::Exec(Game* game) {
    game->exec();
    delete game;
}
/***********************************************************************//**
	
***************************************************************************/
void Game::exec() {
    std::ostringstream buff;
    buff << "gamestart";
    for(int i = 0; i < playerList_.size(); i++) {
        buff << " " << ('A' + i) << " noname";
    }
    fprintf(stderr, "%s %s\n", __FUNCTION__, buff.str().c_str());
    sendAll(buff.str().c_str());
}
/***********************************************************************//**
	全てのプレイヤーにコマンドを送る
	@param	command	コマンド
***************************************************************************/
void Game::sendAll(const char* command) {
    for(PlayerVector::iterator iter = playerList_.begin();
        iter != playerList_.end();
        iter++) {
        (*iter)->send(command);
    }
}
/***********************************************************************//**
	プレイヤーからのメッセージを受信する
***************************************************************************/
void Game::recv(Player* player, const Command& command) {
    boost::mutex::scoped_lock mutex(mutex_);
}
/***********************************************************************//**
	$Id: Game.cpp 80 2009-03-28 13:08:47Z yatsuhashi $
***************************************************************************/
}	/* namespace server */
}	/* namespace openmj */
