/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef __OPENMJ_GUI_RESOURCE_H__
#define __OPENMJ_GUI_RESOURCE_H__

#include "wx/wx.h"
#include "libmahjong.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	リソース.
***************************************************************************/
class Resource {
  public:
    static const int HAI_WIDTH	= 24;
    static const int HAI_HEIGHT	= 32;
    static const int HAI_THICK	= 12;

    enum {
        TENBOU_100, 
        TENBOU_1000, 
        TENBOU_5000, 
        TENBOU_10000
    };

  private:
    wxImage image_;

    static const Resource* instance;

  private:
    Resource();

  public:
    wxImage getImage(const wxRect& rect, int rotate = 0) const;
    wxImage getHaiImage(const mahjong::Hai* hai, int rotate) const;
    wxImage getTsumogiriImage(int rotate) const;
    wxImage getTenbouImage(int tenbou, int rotate = 0) const;

    static const Resource* getInstance();
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
#endif	/* __RESOURCE_H__ */
