/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#ifndef __OPENMJ_GUI_DRAWPACKETHAI_H__
#define __OPENMJ_GUI_DRAWPACKETHAI_H__

#include "wx/wx.h"
#include "libmahjong.h"
#include "DrawPacket.h"
#include "Color.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	
***************************************************************************/
class DrawPacketHai : public DrawPacket {
    typedef DrawPacket super;

  public:
    enum {
        FLAG_OPEN	= 1 << 0, 
        FLAG_BEND	= 1 << 1, 
        FLAG_CLOSE	= 1 << 2, 
        FLAG_NAKI	= 1 << 3, 
        FLAG_LAST	= 1 << 4, 
        FLAG_UPPER	= 1 << 5, 
        FLAG_TSUMOGIRI	= 1 << 6, 
        FLAG_DISABLE	= 1 << 7, 
    };

  private:
    struct ShapeTable {
        int x;
        int w;
        int offsetX;
        int offsetY;
        int faceX;
        int faceY;
        int tsumogiriX;
        int tsumogiriY;
    };
    static const ShapeTable shapeTable[12];
    static const Color nakiColor;
    static const Color disableColor;
    static const Color lastColor;

  protected:
    const mahjong::Hai* hai_;
    int shape_;
    int rotate_;
    int flag_;

  public:
    DrawPacketHai(const wxPoint& pos, const mahjong::Hai* hai, int rotate, 
                  int flag = 0);

  protected:
    virtual void draw(wxDC& dc) const;
};
/***********************************************************************//**
	$Id: DrawPacketHai.h 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
#endif	/* __DRAWPACKETHAI_H__ */
