/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#ifndef __OPENMJ_GUI_DRAWPACKET_H__
#define __OPENMJ_GUI_DRAWPACKET_H__

#include <queue>
#include <wx/wx.h>

namespace openmj {
namespace gui {
/***********************************************************************//**
	描画パケット.
***************************************************************************/
class DrawPacket {
  private:
    wxPoint pos_;
    int priority_;
    DrawPacket* next_;

  protected:
    DrawPacket(const wxPoint& pos, int priority = 0);
    const wxPoint& getPos() const;

  public:
    DrawPacket* getNext() const;
    void setNext(DrawPacket* next);

    bool operator<(const DrawPacket& other) const;

    virtual void draw(wxDC& dc) const {}
};
/***********************************************************************//**
	$Id: DrawPacket.h 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
#endif	/* __DRAWPACKET_H__ */
