/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#ifndef __OPENMJ_GUI_CHOICE_H__
#define __OPENMJ_GUI_CHOICE_H__

#include <stack>
#include "libmahjong.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	
***************************************************************************/
class Choice {
  public:
    enum {
        MODE_NULL, 
        MODE_SUTEHAI, 
        MODE_CHI, 
        MODE_PON, 
        MODE_KAN
    };

  private:
    const int mode_;
    const mahjong::HaiArray& hais_;
    std::stack<mahjong::HaiArray> maskStack_;
    int current_;
    std::stack<int> choiceStack_;
    mahjong::HaiArray choiced_;

  public:
    Choice(const mahjong::HaiArray& hais, int mode = MODE_SUTEHAI);

    void pushMask(const mahjong::HaiArray& mask);
    void popMask();

    const mahjong::HaiArray& get() const;

    bool setCurrent(int index);
    int getCurrent() const;

    int append();

    bool canChoice(int index) const;
};
/***********************************************************************//**
	$Id: Choice.h 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
#endif	/* __CHOICE_H__ */
