/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#include "Choice.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	コンストラクタ
***************************************************************************/
Choice::Choice(const mahjong::HaiArray& hais, int mode)
    : mode_(mode), 
      hais_(hais), 
      current_(-1)
{}
/***********************************************************************//**
	
***************************************************************************/
void Choice::pushMask(const mahjong::HaiArray& mask) {
    fprintf(stderr, "mask = %s\n", mask.toString().c_str());
    maskStack_.push(mask);
}
/***********************************************************************//**
	
***************************************************************************/
void Choice::popMask() {
    maskStack_.pop();
}
/***********************************************************************//**
	選んだ牌の配列を返す
	@return	選んだ牌の配列
***************************************************************************/
const mahjong::HaiArray& Choice::get() const {
    return choiced_;
}
/***********************************************************************//**
	
***************************************************************************/
bool Choice::setCurrent(int index) {
    if(index < 0 || index >= hais_.getSize()) {
        index = -1;
    }
    bool isChange = (current_ != index);
    current_ = index;
    return isChange;
}
/***********************************************************************//**
	
***************************************************************************/
int Choice::getCurrent() const {
    return current_;
}
/***********************************************************************//**
	
***************************************************************************/
int Choice::append() {
    if(getCurrent() < 0) {
        return MODE_NULL;
    }
    choiced_.append(hais_[getCurrent()]);
    int choiceNum = choiced_.getSize();
    switch(mode_) {
    case MODE_PON:
    case MODE_CHI:
        if(choiceNum < 2) {
            return MODE_NULL;
        }
        break;
    default:
        break;
    }
    return mode_;
}
/***********************************************************************//**
	
***************************************************************************/
bool Choice::canChoice(int index) const {
    if(index < 0 || index >= hais_.getSize()) {
        return false;
    }
    return (maskStack_.empty() ||
            maskStack_.top().isInclude(hais_[index]));
}
/***********************************************************************//**
	$Id: Choice.cpp 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
