/***********************************************************************//**
	@file
	$Revision: 78 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 21:23:43 +0900#$
***************************************************************************/
#include <sstream>
#include <assert.h>
#include "Version.h"

namespace openmj {
/***********************************************************************//**
	コンストラクタ
	@param	major	メジャーバージョン番号
	@param	minor	マイナーバージョン番号
***************************************************************************/
Version::Version(unsigned short major, unsigned short minor)
    : major_(major), 
      minor_(minor)
{}
/***********************************************************************//**
	コンストラクタ
	@param	str	バージョンを表す文字列
***************************************************************************/
Version::Version(const char* str) {
    std::istringstream buff(str);
    char c;
    buff >> major_ >> c >> minor_;
    assert(c == '.');
}
/***********************************************************************//**
	文字列に変換する
***************************************************************************/
std::string Version::toString() const {
    std::ostringstream buff;
    buff << major_ << "." << minor_;
    return buff.str();
}
/***********************************************************************//**
	比較する
	@param	other	比較対象
	@return		自身の方が古いとき負、同じとき真、新しいとき正
***************************************************************************/
int Version::compare(const Version& other) const {
    return (major_ != other.major_)
        ? (major_ - other.major_)
        : (minor_ - other.minor_);
}
/***********************************************************************//**
	メジャーバージョンを比較する
	@param	other	比較対象
	@return		自身の方が古いとき負、同じとき真、新しいとき正
***************************************************************************/
int Version::compareMajor(const Version& other) const {
    return (major_ - other.major_);
}
/***********************************************************************//**
	$Id: Version.cpp 78 2009-03-28 12:23:43Z yatsuhashi $
***************************************************************************/
}	/* namespace openmj */
