/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef __OPENMJ_SOCKET_H__
#define __OPENMJ_SOCKET_H__

#include <string>
#include <vector>

namespace openmj {
class Command;
/***********************************************************************//**
	
***************************************************************************/
class Socket {
  public:
    static const int EOL_SIZE = 2;
    static const char EOL[EOL_SIZE + 1];
    static const int INVALID_FD = -1;

  private:
    int fd_;

  public:
    Socket();
    ~Socket();

    bool connect(const char* host, int port);
    bool listen(int port, int backlog = 5);
    Socket* accept();

    bool isOpen() const;
    void close();

    bool recv(std::string& msg);
    bool recvCommand(Command& command);
    bool send(const char* msg);
    bool send(const std::string& msg);

    static void Initialize();
    static void Finalize();

  private:
    Socket(int fd);
    void open();
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace openmj */
#endif	/* __OPENMJ_SOCKET_H__ */
