/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#include "Player.h"

namespace openmj {
/***********************************************************************//**
	コンストラクタ
***************************************************************************/
Player::Player(const char* name)
    : name_(name ? name : "noname"), 
      point_(0)
{}
/***********************************************************************//**
	名前をセットする
	@param	name	名前
***************************************************************************/
void Player::setName(const char* name) {
    name_ = name;
}
/***********************************************************************//**
	名前を参照する
	@return	名前
***************************************************************************/
const std::string& Player::getName() const {
    return name_;
}
/***********************************************************************//**
	点数を参照する
	@return	点数
***************************************************************************/
int Player::getPoint() const {
    return point_;
}
/***********************************************************************//**
	点数をセットする
	@param	point	点数
	@return		点数
***************************************************************************/
int Player::setPoint(int point) {
    point_ = point;
    return point_;
}
/***********************************************************************//**
	点数を加(減)算する
	@param	add	加える値
	@return		点数
***************************************************************************/
int Player::addPoint(int add) {
    point_ += add;
    return point_;
}
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace openmj */
