/***********************************************************************//**
	@file
	$Revision: 77 $
	$Author: yatsuhashi $
	$Date:: 2009-03-26 02:38:16 +0900#$
***************************************************************************/
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include "AgariTest.h"

namespace mahjong {
/***********************************************************************//**
	タンヤオ
***************************************************************************/
void AgariTest::testTanyao() {
    Agari agari = GetAgari("4m4m4m5m6m7m2p3p4p4p5p6p4s4s", "4m");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_TANYAO));
    CPPUNIT_ASSERT(agari.getHan() == 1);
}
/***********************************************************************//**
	役牌.
***************************************************************************/
void AgariTest::testYakuhai() {
    Agari agari = GetAgari("6m7m8m3p4p5p6s6s6s7s7s7z7z7z", "6s");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_YAKUHAI));
    CPPUNIT_ASSERT(agari.getHan() == 1);
}
/***********************************************************************//**
	平和
***************************************************************************/
void AgariTest::testPinfu() {
    Agari agari = GetAgari("3m4m5m7m8m9m7p8p9p2s3s4s6s6s", "9m");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_PINFU));
    CPPUNIT_ASSERT(agari.getHan() == 1);
}
/***********************************************************************//**
	一盃口
***************************************************************************/
void AgariTest::testIpeikou() {
    Agari agari = GetAgari("1m2m3m2p2p3p3p4p4p5s6s7s9s9s", "3p");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_IPEIKOU));
    CPPUNIT_ASSERT(agari.getHan() == 1);
    {
        Agari agari = GetAgari("2p2p2p3p3p3p4p4p4p5s6s7s9s9s", "3p");
        CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_IPEIKOU));
        CPPUNIT_ASSERT(agari.getHan() == 1);
    }
}
/***********************************************************************//**
	三色同順
***************************************************************************/
void AgariTest::testSanshoku() {
    Agari agari = GetAgari("2m3m4m2p3p4p2s3s4s6s7s8s9s9s", "9s");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_SANSHOKU));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	一気通貫
***************************************************************************/
void AgariTest::testItsu() {
    Agari agari = GetAgari("1m2m3m4m5m6m7m8m9m9p9p9p2s2s", "1m");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_ITSU));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	チャンタ
***************************************************************************/
void AgariTest::testChanta() {
    Agari agari = GetAgari("1m1m7m8m9m1p2p3p9m9m9m4z4z4z", "4z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_CHANTA));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	七対子
***************************************************************************/
void AgariTest::testChitoi() {
    Agari agari = GetAgari("4m4m7m7m5p5p6p6p4s4s3z3z5z5z", "5z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_CHITOI));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	対々和
***************************************************************************/
void AgariTest::testToitoi() {
    Agari agari = GetAgari("3m3m3m5s5s5s7s7s<4z4z4z><7p7p7p>", "3m");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_TOITOI));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	三暗刻
***************************************************************************/
void AgariTest::testSananko() {
    Agari agari = GetAgari("2m2m2m3m3m3m9p9p9p4s5s6s8s8s", "5s");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_SANANKO));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	三色同刻
***************************************************************************/
void AgariTest::testSanshokudoukou() {
    Agari agari = GetAgari("4m4m4m1p2p3p7s7s<4p4p4p><4s4s4s>", "1p");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_SANSHOKUDOUKOU));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	三槓子
***************************************************************************/
void AgariTest::testSankantsu() {
    Agari agari = GetAgari("5m6m7m1p1p<3z3z3z3z><6m6m6m6m>(9p9p9p9p)", "5m");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_SANKANTSU));
    CPPUNIT_ASSERT(agari.getHan() == 2);
}
/***********************************************************************//**
	小三元
***************************************************************************/
void AgariTest::testShosangen() {
    Agari agari = GetAgari("5m6m7m6p7p8p5z5z5z6z6z<7z7z7z>", "5z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_SHOSANGEN));
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_YAKUHAI));
    CPPUNIT_ASSERT(agari.getHan() == 4);
}
/***********************************************************************//**
	混老頭
***************************************************************************/
void AgariTest::testHonroutou() {
    Agari agari = GetAgari("1m1m1m9p9p3z3z3z<9m9m9m><1s1s1s>", "3z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_HONROUTOU));
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_TOITOI));
    CPPUNIT_ASSERT(agari.getHan() == 4);
}
/***********************************************************************//**
	ダブリー
***************************************************************************/
/***********************************************************************//**
	混一色
***************************************************************************/
void AgariTest::testHonitsu() {
    Agari agari = GetAgari("1m1m1m2m3m4m5m5m5m9m9m4z4z4z", "4z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_HONITSU));
    CPPUNIT_ASSERT(agari.getHan() == 3);
}
/***********************************************************************//**
	純チャン
***************************************************************************/
void AgariTest::testJunchan() {
    Agari agari = GetAgari("1m2m3m7m8m9m9m9m1p2p3p7s8s9s", "8s");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_JUNCHAN));
    CPPUNIT_ASSERT(agari.getHan() == 3);
}
/***********************************************************************//**
	二盃口
***************************************************************************/
void AgariTest::testRyanpeikou() {
    Agari agari = GetAgari("4m4m5m5m6m6m7p7p8p8p9p9p4s4s", "8p");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_RYANPEIKOU));
    CPPUNIT_ASSERT(agari.getHan() == 3);
}
/***********************************************************************//**
	清一色
***************************************************************************/
void AgariTest::testChinitsu() {
    Agari agari = GetAgari("1m2m3m4m5m6m6m7m8m8m8m8m9m9m", "9m");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKU_CHINITSU));
    CPPUNIT_ASSERT(agari.getHan() == 6);
}
/***********************************************************************//**
	四暗刻
***************************************************************************/
void AgariTest::testSuanko() {
    Agari agari = GetAgari("6m6m6m1p1p1p8s8s2z2z2z6z6z6z", "6z", false);
    CPPUNIT_ASSERT(agari.isYakuman());
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_SUANKO));
}
/***********************************************************************//**
	国士無双
***************************************************************************/
void AgariTest::testKokushi() {
    Agari agari = GetAgari("1m9m1p9p1s9s1z1z2z3z4z5z6z7z", "7z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_KOKUSHI));
    CPPUNIT_ASSERT(agari.getYakuman() == 1);
}
/***********************************************************************//**
	大三元
***************************************************************************/
void AgariTest::testDaisangen() {
    Agari agari = GetAgari("1m2m3m4p4p5z5z5z6z6z6z7z7z7z", "5z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_DAISANGEN));
    CPPUNIT_ASSERT(agari.isYakuman());
}
/***********************************************************************//**
	大四喜
***************************************************************************/
void AgariTest::testDaisushi() {
    Agari agari = GetAgari("1s1s1z1z1z2z2z2z3z3z3z4z4z4z", "4z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_DAISUSHI));
    CPPUNIT_ASSERT(agari.getYakuman() == 2);
}
/***********************************************************************//**
	小四喜
***************************************************************************/
void AgariTest::testShosushi() {
    Agari agari = GetAgari("1s2s3s1z1z1z2z2z2z3z3z3z4z4z", "4z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_SHOSUSHI));
    CPPUNIT_ASSERT(agari.getYakuman() == 1);
}
/***********************************************************************//**
	緑一色
***************************************************************************/
void AgariTest::testRyuisou() {
    Agari agari = GetAgari("2s3s4s4s4s6s6s6s8s8s8s6z6z6z", "6z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_RYUISOU));
    CPPUNIT_ASSERT(agari.getYakuman() == 1);
}
/***********************************************************************//**
	九蓮宝燈
***************************************************************************/
void AgariTest::testChuren() {
    Agari agari = GetAgari("1m1m1m2m3m4m5m6m7m8m8m9m9m9m", "8m");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_CHUREN));
    CPPUNIT_ASSERT(agari.getYakuman() == 1);
}
/***********************************************************************//**
	字一色
***************************************************************************/
void AgariTest::testTsuisou() {
    Agari agari = GetAgari("1z1z2z2z2z3z3z3z6z6z6z7z7z7z", "7z");
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_TSUISOU));
    CPPUNIT_ASSERT(agari.getYakuman() == 1);
}
/***********************************************************************//**
	清老頭
***************************************************************************/
void AgariTest::testChinroutou() {
    Agari agari = GetAgari("1m1m9m9m9m1p1p1p9p9p9p9s9s9s", "9s");
    CPPUNIT_ASSERT(agari.isYakuman());
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_CHINROUTOU));
}
/***********************************************************************//**
	四槓子
***************************************************************************/
void AgariTest::testSukantsu() {
    Agari agari = 
        GetAgari("1m1m(6m6m6m6m)(5p5p5p5p)<3z3z3z3z><7s7s7s7s>", "1m");
    CPPUNIT_ASSERT(agari.isYakuman());
    CPPUNIT_ASSERT(agari.isInclude(Agari::YAKUMAN_SUKANTSU));
}
/***********************************************************************//**
	
***************************************************************************/
Agari AgariTest::GetAgari(const char* str, const char* agariHai, 
                          bool isRon) {
    Hand hand;
    hand.open(str);
    Agari agari;
    CPPUNIT_ASSERT(hand.getAgari(Hai::Get(agariHai), isRon, &agari));
    return agari;
}
/***********************************************************************//**
	$Id: AgariTest.cpp 77 2009-03-25 17:38:16Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
