/***********************************************************************//**
	@file
	$Revision: 59 $
	$Author: yatsuhashi $
	$Date:: 2009-03-06 03:13:18 +0900#$
***************************************************************************/
#include "Kawa.h"

namespace mahjong {
/***********************************************************************//**
	捨て牌を追加する.
	@param	hai	捨て牌
	@return		捨て牌インスタンス
***************************************************************************/
Sutehai& Kawa::append(const Hai* hai) {
    array.push_back(Sutehai(hai));
    return array.back();
}
/***********************************************************************//**
	サイズを返す.
	@return		捨て牌の数
***************************************************************************/
int Kawa::getSize() const {
    return array.size();
}
/***********************************************************************//**
	インデックスの位置の捨て牌を返す.
	@param	index	インデックス
	@return		捨て牌インスタンス
***************************************************************************/
const Sutehai& Kawa::operator[](int index) const {
    return array.at(index);
}
/***********************************************************************//**
	最後の捨て牌を返す.
	@return		最後の捨て牌インスタンス
***************************************************************************/
Sutehai& Kawa::getLast() {
    return array.back();
}
/***********************************************************************//**
	河をクリアする.
***************************************************************************/
void Kawa::clear() {
    array.clear();
}
/***********************************************************************//**
	$Id: Kawa.cpp 59 2009-03-05 18:13:18Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
