/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef __LIBMAHJONG_HAIARRAY_H__
#define __LIBMAHJONG_HAIARRAY_H__

#include <vector>
#include <string>
#include "libmahjong/Hai.h"

namespace mahjong {
/***********************************************************************//**
	牌の配列.
***************************************************************************/
class HaiArray {
  private:
    typedef std::vector<const Hai*> HaiVector;

  private:
    mutable HaiVector array_;

  public:
    HaiArray() {}
    HaiArray(const char* str);

    const Hai* operator[](int index) const;

    HaiArray& append(const Hai* hai);
    HaiArray& append(const HaiArray& other);

    const Hai* removeSame(const Hai* hai);
    const Hai* removeEqual(const Hai* hai);
    int remove(const Hai* hai, int num = 1);

    int count(const Hai* hai) const;
    int countEqual(const Hai* hai) const;
    int countUniqueEqual() const;
        
    bool isInclude(const Hai* hai) const;
    bool isIncludeEqual(const Hai* hai) const;

    int getSize() const;
    bool isEmpty() const;

    void clear();
    void sort();
    void shuffle();

    HaiArray& unique();
    HaiArray getUnique() const;
    HaiArray& uniqueEqual();

    std::string toString() const;
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace mahjong */
#endif	/* __LIBMAHJONG_HAIARRAY_H__ */
