##
#	$Id: test_mahjong.rb 21 2008-11-16 18:27:54Z yatsuhashi $
#
require 'test/unit'
require 'mahjong'

class TestHand < Test::Unit::TestCase
  TEHAI = {
    :HAIPAI => '3m6m9m4p4p6p8p1s2s3z3z4z6z7z', 
    :KOKUSHI => '1m9m1p9p1s9s1z2z3z4z5z6z7z7z', 
    :RYUISO => '8s8s<6z6z6z><2s2s2s>(6s6s6s6s)(3s3s3s3s)'
  }

  def test_richi
  end

  def test_tsumo
    agari = get_agari('1m1m1m7m8m9m2s2s2s7s8s9s2z2z', '8s', false)
    assert(agari)
    assert(agari.include?(:TSUMO))
    assert_equal(agari.src_fu, 36)
  end

  def test_yakuhai
    agari = get_agari('1m2m3m7m7m7m2s2s7s8s9s<5z5z5z>', '9s', false)
    assert(agari)
    assert(agari.include?(:YAKUHAI))
    assert_equal(agari.src_fu, 30)
  end

  def test_tanyao
    agari = get_agari('2m2m2m5m6m7m3p4p5p2s2s6s7s8s', '8s', true)
    assert(agari)
    assert(agari.include?(:TANYAO))
    assert_equal(agari.src_fu, 34)
  end

  def test_pinfu
    agari = get_agari('1m2m3m5m6m7m1p2p3p5p6p7p8p8p', '5m', false)
    assert(agari)
    assert(agari.include?(:PINFU))
    assert_equal(agari.src_fu, 20)

    agari = get_agari('1m2m3m5m6m7m1p2p3p5p6p7p8p8p', '3p', false)
    assert(agari)
    assert(!agari.include?(:PINFU))
    assert_equal(agari.src_fu, 24)
  end

  def test_ipeikou
    agari = get_agari('5m6m7m9m9m7p7p8p8p9p9p1s2s3s', '6m', true)
    assert(agari)
    assert(agari.include?(:IPEIKOU))
  end

  def test_parse
    TEHAI.each_value { |tehai|
      assert_equal(Mahjong::Hand.new(tehai).to_s, tehai)
    }
  end

  def test_menzen
    tehai = Mahjong::Hand.new(TEHAI[:KOKUSHI])
    assert(tehai.menzen?)
    tehai = Mahjong::Hand.new(TEHAI[:RYUISO])
    assert(!tehai.menzen?)
  end

  def test_kokushi
    tehai = Mahjong::Hand.new(TEHAI[:KOKUSHI])
    assert(tehai.kokushi?)
    tehai = Mahjong::Hand.new(TEHAI[:RYUISO])
    assert(!tehai.kokushi?)
  end

  def test_chitoi
    agari = get_agari('6m7m7m1p1p3p3p4p4p7p7p6z6z6m', '6m', false)
    tehai = Mahjong::Hand.new('1m1m3m3m5m5m2p2p4p4p6s6s8s8s')
    agari = tehai.get_agari(Mahjong::Hai['1m'])
    assert(agari && agari.include?(:CHITOI))
    tehai = Mahjong::Hand.new('1m1m2m2m3m3m1p1p2p2p3p3p1s1s')
    agari = tehai.get_agari(Mahjong::Hai['1m'])
    assert(agari && !agari.include?(:CHITOI))
  end

  def test_daisangen
    tehai = Mahjong::Hand.new('2m3m4m2p2p5z5z5z6z6z6z7z7z7z')
    agari = tehai.get_agari(Mahjong::Hai['7z'], true)
    assert(agari && agari.include?(:DAISANGEN))
  end

  def test_shosangen
    tehai = Mahjong::Hand.new('2m3m4m2p2p2p5z5z5z6z6z6z7z7z')
    agari = tehai.get_agari(Mahjong::Hai['7z'], true)
    assert(agari && agari.include?(:SHOSANGEN) && agari.include?(:YAKUHAI))
  end

  def test_misc
  end

  private

  def get_agari(str, agarihai, is_ron, is_pure = false)
    hand = Mahjong::Hand.new(str)
    unless is_pure
      hand.clear_pure
    end
    agari = hand.get_agari(Mahjong::Hai[agarihai], is_ron)
    p(agari)
    #p(agari.point)
    agari
  end
end
