##
#	$Id: hai.rb 22 2009-01-31 17:12:01Z yatsuhashi $
#
module Mahjong
  class Hai
    include Comparable

    COLOR_MANZU	= 0
    COLOR_PINZU	= 1
    COLOR_SOUZU	= 2
    COLOR_ZIHAI	= 3
    COLORS = [ 'm', 'p', 's', 'z' ]

    INSTANCE = Hash.new

    private_class_method :new

    #
    def initialize(str)
      match = /^([1-9])([mpsz])$/i.match(str)
      unless match
        raise(Error, "illegal hai, '#{str}'")
      end
      @num = match[1].to_i
      color = match[2].dup
      @is_dora = !color.downcase!.nil?
      @color = COLORS.index(color)
      @str = str
    end
    attr_reader :num, :color

    #
    def dora?
      @is_dora
    end

    # 字牌？
    def zihai?
      @color == COLOR_ZIHAI
    end

    # ヤオチュウ牌？
    def yaochu?
      zihai? or @num == 1 or @num == 9
    end

    # 三元牌？
    def sangenpai?
      zihai? and @num > 4
    end

    # 役牌？
    def yakuhai?(kaze)
      sangenpai? or kaze.include?(self)
    end

    #
    def <=>(other)
      if other.nil?
        nil
      else
        unless other.is_a?(Hai)
          raise(Error)
        end
        [ @color, @num ] <=> [ other.color, other.num ]
      end
    end

    #
    def *(num)
      hais = Array.new
      num.times { hais << self }
      hais
    end

    #
    def succ
      case @color
      when COLOR_MANZU, COLOR_PINZU, COLOR_SOUZU
        num = (@num < 9) ? @num + 1 : 1
      when COLOR_ZIHAI
        if @num <= 4
          num = (@num < 4) ? @num + 1 : 1
        else
          num = (@num < 7) ? @num + 1 : 5
        end
      end
      self.class["#{num}#{COLORS[@color]}"]
    end

    #
    def +(num)
      num += @num
      if num >= 1 and num <= 9
        self.class["#{num}#{COLORS[@color]}"]
      else
        nil
      end
    end

    #
    def -(num)
      self + (-num)
    end

    #
    def to_s
      @str
    end

    #
    def to_k
      if @color == COLOR_ZIHAI
        [ '東', '南', '西', '北', '白', '発', '中' ][@num - 1]
      else
        to_s
      end
    end


    #
    def self.[](str)
      if str
        INSTANCE[str] ||= new(str)
      end
    end

    #
    def self.parse(str)
      hais = HaiArray.new
      str.scan(/[1-9][mpsz]/i) { |hai|
        hais << self[hai]
      }
      hais
    end

    #
    def self.each(&proc)
      4.times { |i|
        [ 9, 9, 9, 7 ][i].times { |j|
          proc.call(self["#{j + 1}#{COLORS[i]}"])
        }
      }
    end
  end
end
