/*
 * OpenI2CRADIO
 * I/O Port defines.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef IODEF_H
#define	IODEF_H
#ifdef __SDCC
#else
#include <xc.h>
#define _XTAL_FREQ 8000000
#endif
#ifdef	__cplusplus
extern "C" {
#endif

/*
 * LCD(ACM1602 Type)
 */
// If you use I2C-Type ACM1602, You should define, otherwise #undef.
#undef _USE_I2C_1602
#define _LCD_IF_4BIT

/*
 * Machine depended flags
 */
#if defined(__SDCC)
#if defined(pic18f23k22) || defined(pic18f24k22) || defined(pic18f25k22) || defined(pic18f26k22)
#define _I2C_IO_TWO_MSSPS
#define _PIO_HAS_THREE
#endif

#if defined(pic18f23k20) || defined(pic18f24k20) || defined(pic18f25k20) || defined(pic18f26k20)
#define _I2C_IO_ONE_MSSP
#define _PIO_HAS_THREE
#endif

#if defined(pic18f43k20) || defined(pic18f44k20) || defined(pic18f45k20) || defined(pic18f46k20)
#define _I2C_IO_ONE_MSSP
#define _PIO_HAS_FIVE
#endif
#else // __XC
#if defined(__18F23K22) || defined(__18F24k22) || defined(__18F25K22) || defined(__18F26K22)
#define _I2C_IO_TWO_MSSPS
#define _PIO_HAS_THREE
#endif

#if defined(__18F23K20) || defined(__18F24K20) || defined(__18F25K20) || defined(__18F26K20)
#define _I2C_IO_ONE_MSSP
#define _PIO_HAS_THREE
#endif

#if defined(__18F43K20) || defined(__18F44K20) || defined(__18F45K20) || defined(__18F46K20)
#define _I2C_IO_ONE_MSSP
#define _PIO_HAS_FIVE
#endif
#endif

/*
 * MAP OF IOPORT
 *
 * RE3: VPP (ICSP Programming Voltage) / MCLR, Dont use for I/O.
 *
 * PORTA/B/C USED basic.
 *
 * PORTA: RA0 : ADC(IN) to measure battery .
 *        RA1 : SLOT D(OUT)
 *        RA2-RA5 : READ
 *        RA6-RA7 : Used for CLOCK, connect to 8MHz resonator.
 *
 * PORTB: RB0 : Light Out
 *        RB1 : Light
 *        RB2 : FUNC
 *        RB3 : DEL / BAND
 *        RB4-RB5 : RESERVED
 *        RB6-RB7 : FOR ICSP
 *
 * PORTC: RC0 : LED
 *        RC1 : SLOT A
 *        RC2 : SLOT B
 *        RC3-RC4 : SCL/SDA
 *        RC5 : SLOT C
 *        RC6-RC7 : USART
 *
 * In addition, usage of PARALLEL-LCD,You should use 40Pin(or greater) PIC.
 * ON 4BIT LCD I/F:
 *
 * PORTD: RD0: LCD RS
 *        RD1: LCD RW
 *        RD2: LCD EN
 *        RD3: RESERVED.
 *        RD4-RD7 : LCD DATA(DB4-DB7)
 *
 * PORTD: RE0: FM AMP SW(OUT)
 *        RE1: MW AMP SW(OUT)
 *        RE2: SW AMP SW(OUT)
 *        RE3: VPP (ICSP Programming Voltage) / MCLR
 *
 * ON 8BIT LCD I/F:
 * PORTD: RD0-RD7 : LCD DATA(DB0-DB7)
 * PORTE: RE0: LCD RS
 *        RE1: LCD RW
 *        RE2: LCD EN
 *        RE3: VPP (ICSP Programming Voltage) / MCLR
 */

#define TRIS_A_VAL   0b11000000
#define AN_A_VAL     0b00000000
#define TRIS_B_VAL   0b11111111 /* PORTB as INPUT.*/
#define AN_B_VAL     0b00000000
#define TRIS_C_VAL_O 0b11011000 /* FOR I2C-WRITE */
#define TRIS_C_VAL_I 0b11011000 /* FOR I2C-WRITE */
#define AN_C_VAL     0b00000000
#define TRIS_D_VAL   0b00000000 /* FOR OUTPUT, LCD(Optional) */
#ifdef _LCD_IF_4BIT
 #define TRIS_D_RVAL 0xf0 /* FOR INPUT*/
#else
 #define TRIS_D_RVAL 0b11111111 /* FOR INPUT*/
#endif
#define TRIS_E_VAL   0b00000100 /* FOR OUTPUT, ADC, PSP=OFF */
#define _BATT_ADC AN7
#define _ADC_INITF _ANS7
#define _ADCH_INITF 0x00
#define _PORT_MUTE LATEbits.LATE0
#define _PORT_RADIOPOW LATEbits.LATE1
#ifdef __SDCC
#define _LCD_BACKLIGHT _PORTC_RC2
#else
#define _LCD_BACKLIGHT _PORTC_RC2_MASK
#endif
#define _LCD_PORT LATC
#define _AM_STATLAMP  LATAbits.LATA4
#define _FM_STATLAMP  LATAbits.LATA5
#define _POW_STATLAMP LATDbits.LATD3

#define _KEY_SENDPORT LATA
#define _KEY_RECVPORT PORTB
#define _KEY_GRP1MASK 0x01
#define _KEY_GRP2MASK 0x02
#define _KEY_GRP3MASK 0x04
#define _KEY_GRP4MASK 0x08
#define _KEY_SENDPORTMASK (_KEY_GRP1MASK | _KEY_GRP2MASK | _KEY_GRP3MASK | _KEY_GRP4MASK)
#define _KEY_SEND_GRP1 LATAbits.LATA0
#define _KEY_SEND_GRP2 LATAbits.LATA1
#define _KEY_SEND_GRP3 LATAbits.LATA2
#define _KEY_SEND_GRP4 LATAbits.LATA3
#define _KEY_POS1MASK(p) p.b0
#define _KEY_POS2MASK(p) p.b1
#define _KEY_POS3MASK(p) p.b2
#define _KEY_POS4MASK(p) p.b3

typedef  union {
    struct {
    unsigned BIT0A:1;
    unsigned BIT1A:1;
    unsigned BIT2A:1;
    unsigned BIT3A:1;

    unsigned BIT0B:1;
    unsigned BIT1B:1;
    unsigned BIT2B:1;
    unsigned BIT3B:1;

    unsigned BIT0C:1;
    unsigned BIT1C:1;
    unsigned BIT2C:1;
    unsigned BIT3C:1;

    unsigned BIT0D:1;
    unsigned BIT1D:1;
    unsigned BIT2D:1;
    unsigned BIT3D:1;

    };
    unsigned char byte[2];
} keyin_defs;

enum {
    charcode_null = 0,
    charcode_1,
    charcode_2,
    charcode_3,
    charcode_4,
    charcode_5,
    charcode_6,
    charcode_7,
    charcode_8,
    charcode_9,
    charcode_a,
    charcode_b,
    charcode_c,
    charcode_d,
    charcode_e,
    charcode_f,
    charcode_0,
    // Special keys was removed.
};

/*
 * LCD Control: Default register values, You should re-define in iodef.h if you need.
 */


#ifdef _LCD_IF_4BIT
/*
 * 4bit Interface, Used Below:
 * PORTD: RD0 : RS
 *        RD1 : RW
 *        RD2 : EN
 *        RD4-RD7: DATA(4-7).
 */
 #ifndef _LCDPORT_DATA
#define _LCDPORT_DATA PORTD
#define _LCDPORT_TRIS_DATA TRISD
#define _LCDPORT_LATCH_DATA LATD
#define _LCDPORT_BUSYMASK 0b10000000
#define _LCDPORT_READMASK TRIS_D_RVAL
#define _LCDPORT_DATA_SHIFT 4
 #endif

 #ifndef _LCDPORT_CONT
#define _LCDPORT_CONT PORTD
#define _LCDPORT_TRIS_CONT TRISD
#define _LCDPORT_CONT_LATCH LATD
#define _LCDPORT_CONT_RSbit b0
#define _LCDPORT_CONT_RWbit b1
#define _LCDPORT_CONT_ENbit b2
#define _LCDPORT_CONT_BLbit b3
#ifdef __SDCC
#define _LCDPORT_CONT_RS _PORTD_RD0
#define _LCDPORT_CONT_RW _PORTD_RD1
#define _LCDPORT_CONT_EN _PORTD_RD2
#else
#define _LCDPORT_CONT_RS _PORTD_RD0_MASK
#define _LCDPORT_CONT_RW _PORTD_RD1_MASK
#define _LCDPORT_CONT_EN _PORTD_RD2_MASK
#endif
#endif

#else
/*
 * 8bit Interface, Used Below:
 * PORTE: RE0 : RS
 *        RE1 : RW
 *        RE2 : EN
 * PORTD: RD0-RD7: DATA(0-7).
 */
// 8bit I/F
 #ifndef _LCDPORT_DATA
#define _LCDPORT_DATA PORTD
#define _LCDPORT_TRIS_DATA TRISD
#define _LCDPORT_LATCH_DATA LATD
#define _LCDPORT_BUSYMASK 0b10000000
#define _LCDPORT_READMASK TRIS_D_RVAL
 #endif

 #ifndef _LCDPORT_CONT
#define _LCDPORT_CONT PORTE
#define _LCDPORT_TRIS_CONT TRISE
#define _LCDPORT_CONT_RSbit 0
#define _LCDPORT_CONT_RWbit 1
#define _LCDPORT_CONT_ENbit 2
#define _LCDPORT_CONT_RS _PORTE_RE0
#define _LCDPORT_CONT_RW _PORTE_RE1
#define _LCDPORT_CONT_EN _PORTE_RE2
#define _LCDPORT_CONT_LATCH LATE
 #endif
#endif

#ifdef	__cplusplus
}
#endif

#endif	/* IODEF_H */

