/*
 * OpenI2CRADIO
 * Config & Main routine.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif

#include <signal.h>

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"

/*
 * Config words.
 */
#if defined(pic18f23k22) || defined(pic18f24k22) || defined(pic18f25k22) || defined(pic18f26k22)
//#pragma stack 0x200 256 // Set stack size to 256bytes.
#pragma config FOSC=INTIO67,BORV=190,BOREN=ON,PWRTEN=ON
#pragma config WDTEN=ON,WDTPS=32768
#pragma config PBADEN=OFF,MCLRE=EXTMCLR,STVREN=ON,LVP=OFF,DEBUG=ON//,XINST=ON
//#pragma config PBADEN=OFF,MCLRE=EXTMCLR,STVREN=ON,LVP=OFF//,XINST=ON
#pragma config CP0=OFF,CP1=OFF,CPB=OFF,CPD=OFF
#pragma config WRT0=OFF,WRT1=OFF,WRTB=OFF,WRTC=OFF,WRTD=OFF
#pragma config EBTR0=OFF,EBTR1=OFF,EBTRB=OFF
#endif
// For 4xK20 or 2xK20 Series
#if defined(pic18f43k20) || defined(pic18f44k20) || defined(pic18f45k20) || defined(pic18f46k20) || \
    defined(pic18f23k20) || defined(pic18f24k20) || defined(pic18f25k20) || defined(pic18f26k20)

#pragma stack 0x200 256
#pragma config FOSC=HS,FCMEN=ON,PWRT=ON,BOREN=ON,BORV=22
#pragma config WDTEN=ON,WDTPS=32768,PBADEN=OFF,HFOFST=ON,LPT1OSC=OFF,MCLRE=ON
#pragma config STVREN=ON,DEBUG=ON
//#pragma config CP0=OFF,CP1=OFF,CP2=OFF,CP3=OFF
//#pragma config CPB=OFF,CPD=OFF
//#pragma config WRT0=OFF,WRT1=OFF,WRT2=OFF,WRT3=OFF
//#pragma config WRTC=OFF,WRTB=OFF,WRTD=OFF
//#pragma config EBTR0=OFF,EBTR1=OFF,EBTR2=OFF,EBTR3=OFF,EBTRB=OFF
#endif

/*
 * Statuses
  */
unsigned char stereoflag;
unsigned char tuneflag;
unsigned char cnrlevel;
int diffstat;
unsigned int batlevel_6955;
unsigned int battlevel;

int recv_signal;
int backlight_counter;
unsigned char backlight_level;
unsigned char pollkeybuf[33];

//#define _LCD_DEBUG 1
#ifdef __XC
void TMR0_handler(void)
#else
SIGHANDLER(TMR0_handler)
#endif
{

   // Stop timer0
   T0CONbits.TMR0ON = 0;

   // Clear interrupt flag
   INTCONbits.TMR0IF = 0;
   INTCONbits.TMR0IE = 0;;

   return;
}
/*
 * Interrupt wake up every 1ms.
 */
#ifdef __XC
void TMR3_Handler(void)
#else
SIGHANDLER(TMR3_Handler)
#endif
{
    PIR2bits.TMR3IF  = 0;
    PIE2bits.TMR3IE  = 0;
    T3CONbits.TMR3ON = 0;
}

#ifdef __XC
void EXINT_Handler(void)
#else
SIGHANDLER(EXINT_Handler)
#endif
{
    INTCONbits.INT0IE = 0;
    INTCONbits.INT0IF = 0;
    INTCON3bits.INT1IF = 0;
    INTCON3bits.INT2IF = 0;
    INTCON3bits.INT1IE = 0;
    INTCON3bits.INT2IE = 0;

}
#ifdef __XC
void RBIF_handler(void)
#else
SIGHANDLER(RBIF_handler)
#endif
{
    power_on_inthook();
//    if(chk_powerbutton(0, 0) != 0) { // If pressed on
//      power_off(1); //
//    }
}
#ifdef __XC
void EEPROM_handler(void)
#else
SIGHANDLER(EEPROM_handler)
#endif
{
    PIR2bits.EEIF = 0;
    EECON1bits.WREN = 0;
//    if(chk_powerbutton(0, 0) != 0) { // If pressed on
//      power_off(1); //
//    }
}

#ifdef __XC
void INADC_handler(void)
#else
SIGHANDLER(INADC_handler)
#endif
{
//    unsigned int a;
//    a = polladc();
//    if(a != 0xffff) {
//        battlevel = adc_rawtobatt(a);
//    }
}
#ifdef __XC
void I2C_handler(void)
#else
SIGHANDLER(I2C_handler)
#endif
{
    PIR1bits.SSPIF = 0;
}
#ifdef __XC
void I2CBus_handler(void)
#else
SIGHANDLER(I2CBus_handler)
#endif
{
    PIR2bits.BCLIF = 0;
}



#ifdef __SDCC
DEF_INTLOW(intlow_handler)
  DEF_HANDLER(SIG_TMR0, TMR0_handler)
  DEF_HANDLER(SIG_INT0, EXINT_Handler)
//  DEF_HANDLER(SIG_TMR3, I2C_handler)
END_DEF

DEF_INTHIGH(inthigh_handler)
  DEF_HANDLER(SIG_RBIF, RBIF_handler)
  DEF_HANDLER(SIG_EEIF, EEPROM_handler)
  DEF_HANDLER(SIG_TMR3, TMR3_Handler)
  DEF_HANDLER(SIG_TMR0, TMR0_handler)
  DEF_HANDLER(SIG_INT1, EXINT_Handler)
  DEF_HANDLER(SIG_INT2, EXINT_Handler)
  DEF_HANDLER(SIG_AD, INADC_handler)
  //DEF_HANDLER(SIG_SSP, I2C_handler)
  //DEF_HANDLER(SIG_BCOL, I2CBus_handler)
END_DEF
#else
void interrupt low_priority isr(void)
{
  if(INTCONbits.T0IF)  TMR0_handler();
  if(INTCONbits.INT0F) EXINT_Handler();
}
void interrupt isr_high(void)
{
    if(INTCONbits.RBIF)   RBIF_handler();
    if(PIR2bits.EEIF)     EEPROM_handler();
    if(PIR2bits.TMR3IF)   TMR3_Handler();
    if(INTCONbits.TMR0IF) TMR0_handler();
    if(INTCON3bits.INT1F || INTCON3bits.INT2IF) EXINT_Handler();
    if(PIR1bits.ADIF) INADC_handler();
}
#endif


int main(void)
{
    unsigned char c;
    unsigned int sum = 0;
    unsigned char pbutton;
    unsigned char reset_status;
    unsigned char p;
    
#ifdef __SDCC
    OSCCON =  (_IDLEN & 0b11111100) | 0b00111000;
#else
    OSCCON = (_OSCCON_IDLEN_MASK & 0b11111100 ) | 0b00111000;
#endif
    idle_init();
    keyin_init();
    keyin_ioinit();

    batlevel_6955 = 0;
    battlevel = 0;
    WDTCONbits.SWDTEN = 1; // WDT ON.
    reset_status = chk_reset();
#if 1
    switch(reset_status){
        case RESET_POR:
        case RESET_MCLR:
            power_off(0);
            break;
        case RESET_BOR:
            power_off(1); // Save and halt on BOR.
            break;
        case RESET_SOFTWARE: //
            do {
                pbutton = chk_powerbutton();
                ClrWdt();
                if(pbutton == 0) power_off(0); // Button not pressed.
            } while(pbutton == 0);
            break;
        default:
            break;
    }
#endif
    i2c1_init();
    power_on(1);
    intadc_init();
    set_powerlamp(1);
    idle_time_ms(125);
    valinit();

    acm1602_init(0xa0, 1); //Init LCD
    idle_time_ms(125);
    _LOCATE(0,0);  // It's BAD-KNOWHOW, but needs AKIZUKI'S LCD :(
    _PUTCHAR(' '); //
    _LOCATE(0,1);
    printstr("Hello;-)");
    lcd_setbacklight(0xff, 100);
    idle_time_ms(1000);
    check_eeprom();
    // Init AKC6955
    /* Check EEPROM */
    /* Push default parameters to AKC6955*/
    setup_akc6955();
    _CLS();
    _LOCATE(0,0);
    _PUTCHAR(' ');
   update_status();
   update_display();
    ClrWdt();
//    _LOCATE(0,0);
//    printstr("OK");
    do {
        /* Main routine*/
#if 1
        c = pollkeys(pollkeybuf, 60, 1);
       p = 0;
       while(c > 0) {
           setfreq_updown(pollkeybuf[p]);
           c--;
           p++;
       }
#else
       c = pollkey_single();
       setfreq_updown(c);
#endif
//       idle_time_ms(ui_idlecount);
        // Putstring to LCD.
        _LOCATE(0,0);
        pbutton = chk_powerbutton();
        if(pbutton != 0) shutdown(1); // Button pressed.

        if(backlight_counter > 0) {
            backlight_counter--;
            lcd_setbacklight(0xff, backlight_level); // Turn ON
        } else {
            lcd_setbacklight(0x00, 0); // Turn OFF
        }
        update_status();
        update_display();
    } while(1);
}

