/*
 * OpenI2CRADIO
 * Internal ADCONVERTER Handler
 * Copyright (C) 2013-06-20 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */
#include "adc.h"
#include "adc_int.h"
void intadc_init(void)
{
#if defined(pic18f23k22) || defined(pic18f24k22) || defined(pic18f25k22) || defined(pic18f26k22)
    ANSELA = AN_A_VAL;
    ANSELB = AN_B_VAL;
    ANSELC = AN_C_VAL;
#endif
#if defined(pic18f23k20) || defined(pic18f24k20) || defined(pic18f25k20) || defined(pic18f26k20)
    ANSEL=  _ADC_INITF;
    ANSELH = _ADCH_INITF;
#endif
#if defined(pic18f43k20) || defined(pic18f44k20) || defined(pic18f45k20) || defined(pic18f46k20)
    ANSEL=  _ADC_INITF;
    ANSELH = _ADCH_INITF;
#endif
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 0;
    IPR1bits.ADIP = 1; // High
}


#if 0
void startadc(unsigned char ch)
{
    unsigned char a;
    ADCON1bits.VCFG1 = 0;
    ADCON1bits.VCFG0 = 0;
    ADCON2 = 0b10110110;
    a = 0b00000001; // Select AN7, Start.
    switch(ch){
        case 0:
            a |= 0b00011100; // AN7
            break;
        default:
            a |= 0b00011100; // AN7
            break;
    }
    ADCON0 = a;
    // Delay = 5uS + Tc + (tempalature - 25) * 0.05uS
//    delay10tcy(8); // Tc = -13.5pF*(1K + 700 + (13K//39K)) = 1.52uS
    // Wait < 1.52 + 5 + 1.25 = 7.77uS-> 8uS
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 0;
    IPR1bits.ADIP = 1; // High
    ADCON0bits.GO_NOT_DONE = 1;
}

unsigned int polladc(void)
{
    unsigned int a;
    if(ADCON0bits.DONE == 1){ // converting or not enable.
        PIE1bits.ADIE = 1;
        PIR1bits.ADIF = 0;
        return 0xffff;
    } else { // Done, Clear interrupt
//     if(ADCON0bits.ADON == 0){
//         a = 0xffff;
//     } else {
        a = ((ADRESH << 8)  + ADRESL) & 0x03ff;
//     }
     PIE1bits.ADIE = 0;
     PIR1bits.ADIF = 0;
//     ADCON0bits.GO_NOT_DONE = 0;
//        ADCON0bits.ADON = 0;
        return a;
    }
}

unsigned int polladc2(void)
{
    unsigned int a = 0;
    do {
        delay10tcy(8); // 10uS
        a = ((ADRESH << 8)  + ADRESL) & 0x03ff;
    } while(ADCON0bits.DONE == 1);
    return a;
}

void stopadc(void)
{
    ADCON0bits.GO_NOT_DONE = 0;
//    ADCON0bits.ADON = 0;
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 0;
}
#else // Using sdcc's library.

unsigned int polladc(void)
{
    unsigned int a;
    if(ADCON0bits.DONE == 1){ // converting or not enable.
        PIE1bits.ADIE = 1;
        PIR1bits.ADIF = 0;
        return 0xffff;
    } else { // Done, Clear interrupt
        a = ((ADRESH << 8)  + ADRESL) & 0x03ff;
     PIE1bits.ADIE = 0;
     PIR1bits.ADIF = 0;
     ADCON0bits.GO_NOT_DONE = 0;
     return a;
    }
}

#endif

unsigned int adc_rawtobatt(unsigned int b, unsigned int reflevel)
{
    // raw = (reflevel[0.01V] * b) / 1024 * divide :divide = 4
    return ((b >>2) * reflevel) >> 6;
}