/*
 * OpenI2CRADIO
 * Rotary encoder routine(Header).
 * Copyright (C) 2013-10-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif

#include "iodef.h"

#define RENC_PH_A PORTBbits.RB5
#define RENC_PH_B PORTBbits.RB6
#define RENC_TRIS_A TRISBbits.TRISB5
#define RENC_TRIS_B TRISBbits.TRISB6
#define RENC_NONE 0x00
#define RENC_LEFT 0x7f
#define RENC_RIGHT 0xff

extern unsigned char renc_dir;
extern unsigned int renc_count;
extern unsigned char renc_flag;


extern void rencoder_init(void);
extern void rencoder_start(void);
extern void rencoder_restart(void);
extern void rencoder_stop(void);
extern void rencoder_inthook(void);
extern void rencoder_tmrhook(void);
extern void rencoder_count(void);


