/*
 * OpenI2CRADIO
 * I2C EEPROM Handler
 * Copyright (C) 2013-08-25 K.Ohta <whatisthis.sowhat at gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef I2C_EEPROM_H
#define	I2C_EEPROM_H



#include <stdarg.h>
#include <stdio.h>
#ifdef __SDCC
#include <delay.h>
#include <pic18fregs.h>
#endif

#include "i2c_io.h"
#include "idle.h"



#ifdef	__cplusplus
extern "C" {
#endif

#define I2CEEPROM_ADDR 0xa0
#define I2C_ROM_PAGE_SIZE 32



extern unsigned char i2c_eeprom_bytewrite(unsigned char i2caddr, unsigned int addr, unsigned char data);
extern unsigned char i2c_eeprom_byteread(unsigned char i2caddr, unsigned int addr);
extern unsigned char i2c_eeprom_burstwrite(unsigned char i2caddr, unsigned int addr, unsigned char *data, unsigned int bytes);
extern unsigned char i2c_eeprom_burstread(unsigned char i2caddr, unsigned int addr, unsigned char *data, unsigned int bytes);



#ifdef	__cplusplus
}
#endif

#endif	/* I2C_EEPROM_H */

