/*
 * OpenI2CRADIO
 * UI->LCD->Display status.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#endif

#include "commondef.h"
#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"


void print_freq(unsigned char y)
{
    int freq;
    unsigned char band;
    unsigned char cc;
//    _HOME();
    _LOCATE(0, y);
    if(setup.fm != 0){ // FM
        band = setup.fmband;
        if(band < AKC6955_BAND_TV1) {
            printstr("FM");
            _PUTCHAR('1' + (band & 7));
            _PUTCHAR(' ');
        } else if(band < AKC6955_BAND_FMUSER){
            printstr("TV");
            _PUTCHAR('1' + band - AKC6955_BAND_TV1);
            _PUTCHAR(' ');
        } else { // USER
            printstr("FMU");
            _PUTCHAR('0' + setup.fm_userbandnum);
        }
        printstr("  ");
         if(stereoflag != 0){
             cc = 'S';
         } else {
             cc = ' ';
         }
         _PUTCHAR(cc);
         freq = setup.fmfreq;// + diffstat / 100;
         print_numeric_nosupress(freq / 100, 3);
         _PUTCHAR('.');
         print_numeric_nosupress(freq % 100, 2);
         printstr("MHz");
    } else { // AM
        band = setup.amband;
        if(band == AKC6955_BAND_LW) {
            printstr("LW  ");
        } else if(band <AKC6955_BAND_SW1) { //MW
            printstr("MW");
            _PUTCHAR('1' + band - AKC6955_BAND_MW1);
            _PUTCHAR(' ');
        } else if(band < AKC6955_BAND_AMUSER)  { //SW
            printstr("SW");
            print_numeric_nosupress(band - AKC6955_BAND_SW1 + 1, 2);
        } else if(band == AKC6955_BAND_MW4){
            printstr("MW4 ");
        } else {
            printstr("AMU");
            _PUTCHAR('0' + setup.am_userbandnum);
        }
         freq = setup.amfreq;// + diffstat / 10;
         printstr("    ");
         print_numeric_nosupress(freq, 5);
         printstr("KHz");
     }
     _HOME();
}

void update_display(void)
{

    unsigned int vol;
    int sig;

 //   _CLS();
    _LOCATE_0_0();
    printstr("S");
    if(recv_signal > 99){
        _PUTCHAR('+');
    } else {
        _PUTCHAR('0' + recv_signal / 10);
    }
    _PUTCHAR('/');
    if(cnrlevel >= 40) {
        _PUTCHAR('+');
    } else {
        _PUTCHAR('0' + cnrlevel / 4);
    }
    _PUTCHAR(' ');
    set_amfmlamp(~setup.fm);
    _PUTCHAR('W');
//    print_numeric_nosupress((setup.threshold_width & 3) * 10 + (setup.fm_tunepitch & 3), 2);
    print_numeric_nosupress(setup.threshold_width * 10 + setup.fm_tunepitch, 2);
     // vol = volume * 1.5 + prevolume * 3.5[dB]
#if 0
     if(volume > 24) {
         vol = volume - 24;
         vol = (vol * 3 + prevolume * 7) / 2;
         printstr("V:");
         print_numeric_nosupress(vol,2);
     } else {
         printstr("MUTE");
     }
#endif
     _LOCATE(16-5, 0);
     print_numeric_nosupress(battlevel / 100, 1);
     _PUTCHAR('.');
     print_numeric_nosupress(battlevel % 100, 2);
     _PUTCHAR('V');
     print_freq(1);
}
