// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_base/framerate_manager.hpp"
#include "DxLib.h"

framerate_manager::framerate_manager( int fps )
	: fps( fps ),
	  interval( 1000.0f / fps ),
	  frame_count( 0 ),
	  origin_time( DxLib::GetNowCount() ),
	  wait_time( 0 ),
	  update_time( 0 ),
	  FRAME_count( 0 ),
	  last_update( 0 ),
	  average_fps( 0.0f )
{
}

framerate_manager::~framerate_manager()
{
}

void framerate_manager::adjust_framerate()
{
	// ̃t[̕AJEgPi߂
	this->frame_count++;

	// ̃t[̏I_ł̐ԂAvZĂ
	int target_time = this->origin_time + static_cast<int>( this->interval * this->frame_count + 0.5f );

	// ۂɋxގԂ́AԂƌ݂̎ԂƂ̍ƂȂ
	this->wait_time = target_time - DxLib::GetNowCount();

	if ( this->wait_time > 0 )
	{
		DxLib::WaitTimer( this->wait_time );
	}
	// `Ȃǂ interval ȏ̎Ԃꍇ́AԂ̌_Đݒ肷
	else if ( this->wait_time < 0 )
	{
		this->frame_count = 0;
		this->origin_time = DxLib::GetNowCount();
	}
}

void framerate_manager::print_framerate()
{
	// ֋XIɁAt[̊Jnn_ƍl
	this->update_time = DxLib::GetNowCount();
	this->FRAME_count++;

	// Pb̊Ԋuł́AXVȂ
	if ( this->update_time - this->last_update > 1000 )
	{
		this->average_fps = this->FRAME_count * 1000 / float( this->update_time - this->last_update );
		this->last_update = this->update_time;
		this->FRAME_count = 0;
	}

	// t[[gyёOt[̑҂Ԃ\
	int color = DxLib::GetColor( 255, 255, 255 );

	// vCʂɕ`悷
	DxLib::DrawFormatString( 0,  0, color, "[%.2f FPS][%d ms]", this->average_fps, this->wait_time );

#ifdef NEVER_DEFINED

	// R\[ɏo͂
	std::ios_base::fmtflags saveflags = std::cout.setf( std::ios_base::fixed );
	std::streamsize savesize = std::cout.precision( 2 );

	std::cout << "σt[[gF" << this->average_fps << " [fps]A"
	          << "Ot[̑҂ԁF" << this->wait_time << " [ms]" << std::endl;

	std::cout.flags( saveflags );
	std::cout.precision( savesize );

#endif // NEVER_DEFINED

}
