// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_base/dxlib_driver.hpp"
#include "DxLib.h"
#include "graphics/graphic_config.hpp"
#include <stdexcept>

dxlib_driver* dxlib_driver::instance()
{
	static dxlib_driver _instance;
	return &_instance;
}

void dxlib_driver::dispose()
{
	// cwCuĂȂ΁AI
	if ( this->init_done )
	{
		this->end();
		this->init_done = false;
	}
}

bool dxlib_driver::init()
{
	// 640~480A32bpp
	DxLib::SetGraphMode( canvas_width, canvas_height, color_depth );

	// EBhE[hŋN
	DxLib::ChangeWindowMode( TRUE );

	// EBhEʂ́A`ʂ̂Q{̑傫
	DxLib::SetWindowSizeExtendRate( 2.0 );

	// DxLib::ScreenFlip()  VSYNC ҂
	//DxLib::SetWaitVSyncFlag( TRUE );
	DxLib::SetWaitVSyncFlag( FALSE ); // ҂Ԃm邽߂ɁAVSYNCȂ

	// cwCu
	if ( DxLib::DxLib_Init() == -1 )
	{
		throw std::runtime_error( "DxLib_Init: FAILURE" );
	}

	// OtBbNJ[ĥRc@\gȂ
	DxLib::SetUse3DFlag( FALSE );

	// ̉ʂɕ`悷
	DxLib::SetDrawScreen( DX_SCREEN_BACK );

	// cwCu̒ʏfobOpOt@C App.log o͂Ȃ
	DxLib::SetOutApplicationLogValidFlag( FALSE );

	// EBhẼ^Cg
	DxLib::SetMainWindowText( "First Fantasy" );

	// EBhETCYύXȂ
	DxLib::SetWindowSizeChangeEnableFlag( FALSE );

	// gptHg̐ݒ
	DxLib::ChangeFont( "lr SVbN" );
	DxLib::SetFontSize( 10 );
	DxLib::SetFontThickness( 1 );

	return true;
}

void dxlib_driver::end()
{
	// ǂ݂񂾃OtBbNׂč폜
	DxLib::InitGraph();

	// cwCuI
	DxLib::DxLib_End();
}

dxlib_driver::dxlib_driver()
	: init_done( false )
{
	this->init_done = this->init();
}

dxlib_driver::~dxlib_driver()
{
}
