// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "graphics/image_lookup.hpp"
#include "common/character_id.hpp"
#include "graphics/image.hpp"
#include "graphics/sprite.hpp"
#include "DxLib.h"
#include <iostream>

image_lookup::sprite_t image_lookup::hero_to_sprite[ character_id::sizeof_hero_t ] =
{
	image_lookup::dino_char_chips ,
	image_lookup::milia_char_chips,
	image_lookup::maria_char_chips,
	image_lookup::jay_char_chips  ,
};

image_lookup* image_lookup::instance()
{
	static image_lookup _instance;
	return &_instance;
}

image* image_lookup::get_image( image_t image_id )
{
	if ( this->images[ image_id ].get_handle() == -1 )
	{
		( this->*load_image[ image_id ] )();
	}

	return &( this->images[ image_id ] );
}

sprite* image_lookup::get_sprite( sprite_t sprite_id )
{
	if ( this->sprites[ sprite_id ].get_handle() == nullptr )
	{
		( this->*load_sprite[ sprite_id ] )();
	}

	return &( this->sprites[ sprite_id ] );
}

void image_lookup::load_image_window_background()
{
	const char* filename = "data\\graphs\\system\\window_background.bmp";

	DxLib::SetTransColor( 0, 117, 117 );
	int handle = DxLib::LoadGraph( filename );

	if ( handle == -1 )
	{
		std::cerr << "LoadGraph: FAILURE: " << filename << std::endl;
	}

	this->images[ this->window_background ] = image( handle, 320, 240 );
}

void image_lookup::load_image_battle_background_plain()
{
	const char* filename = "data\\field\\battle_background_plain.bmp";

	DxLib::SetTransColor( 0, 117, 117 );
	int handle = DxLib::LoadGraph( filename );

	if ( handle == -1 )
	{
		std::cerr << "LoadGraph: FAILURE: " << filename << std::endl;
	}

	this->images[ this->battle_background_plain ] = image( handle, 320, 184 );
}

void image_lookup::load_image_atb_gauge()
{
	const char* filename = "data\\graphs\\system\\atb_gauge.png";

	DxLib::SetTransColor( 0, 117, 117 );
	int handle = DxLib::LoadGraph( filename );

	if ( handle == -1 )
	{
		std::cerr << "LoadGraph: FAILURE: " << filename << std::endl;
	}

	this->images[ this->atb_gauge ] = image( handle, 62, 8 );
}

void image_lookup::load_sprite_window_frame()
{
	const char* filename = "data\\graphs\\system\\window_frame.bmp";
	static int handle[ 8 ];

	DxLib::SetTransColor( 0, 117, 117 );
	int error = DxLib::LoadDivGraph( filename, 8, 8, 1, 16, 16, handle );

	if ( error == -1 )
	{
		std::cerr << "LoadDivGraph: FAILURE: " << filename << std::endl;
	}

	this->sprites[ this->window_frame ] = sprite( handle, 8, 8, 1, 16, 16 );
}

void image_lookup::load_sprite_dino_char_chips()
{
	const char* filename = "data\\char\\dino_char_chips.png";
	static int handle[ 51 ];

	DxLib::SetTransColor( 0, 117, 117 );
	int error = DxLib::LoadDivGraph( filename, 51, 17, 3, 16, 24, handle );

	if ( error == -1 )
	{
		std::cerr << "LoadDivGraph: FAILURE: " << filename << std::endl;
	}

	this->sprites[ this->dino_char_chips ] = sprite( handle, 51, 17, 3, 16, 24 );
}

void image_lookup::load_sprite_milia_char_chips()
{
	const char* filename = "data\\char\\dino_char_chips.png";
	static int handle[ 51 ];

	DxLib::SetTransColor( 0, 117, 117 );
	int error = DxLib::LoadDivGraph( filename, 51, 17, 3, 16, 24, handle );

	if ( error == -1 )
	{
		std::cerr << "LoadDivGraph: FAILURE: " << filename << std::endl;
	}

	this->sprites[ this->milia_char_chips ] = sprite( handle, 51, 17, 3, 16, 24 );
}

void image_lookup::load_sprite_maria_char_chips()
{
	const char* filename = "data\\char\\dino_char_chips.png";
	static int handle[ 51 ];

	DxLib::SetTransColor( 0, 117, 117 );
	int error = DxLib::LoadDivGraph( filename, 51, 17, 3, 16, 24, handle );

	if ( error == -1 )
	{
		std::cerr << "LoadDivGraph: FAILURE: " << filename << std::endl;
	}

	this->sprites[ this->maria_char_chips ] = sprite( handle, 51, 17, 3, 16, 24 );
}

void image_lookup::load_sprite_jay_char_chips()
{
	const char* filename = "data\\char\\dino_char_chips.png";
	static int handle[ 51 ];

	DxLib::SetTransColor( 0, 117, 117 );
	int error = DxLib::LoadDivGraph( filename, 51, 17, 3, 16, 24, handle );

	if ( error == -1 )
	{
		std::cerr << "LoadDivGraph: FAILURE: " << filename << std::endl;
	}

	this->sprites[ this->jay_char_chips ] = sprite( handle, 51, 17, 3, 16, 24 );
}

image_lookup::image_lookup()
{
	for ( int i = 0 ; i < this->sizeof_image_t ; ++i )
	{
		this->load_image[ i ] = nullptr;
	}

	for ( int i = 0 ; i < this->sizeof_sprite_t ; ++i )
	{
		this->load_sprite[ i ] = nullptr;
	}

	this->load_image[ this->window_background       ] = &image_lookup::load_image_window_background;
	this->load_image[ this->battle_background_plain ] = &image_lookup::load_image_battle_background_plain;
	this->load_image[ this->atb_gauge               ] = &image_lookup::load_image_atb_gauge;

	this->load_sprite[ this->window_frame     ] = &image_lookup::load_sprite_window_frame;
	this->load_sprite[ this->dino_char_chips  ] = &image_lookup::load_sprite_dino_char_chips;
	this->load_sprite[ this->milia_char_chips ] = &image_lookup::load_sprite_milia_char_chips;
	this->load_sprite[ this->maria_char_chips ] = &image_lookup::load_sprite_maria_char_chips;
	this->load_sprite[ this->jay_char_chips   ] = &image_lookup::load_sprite_jay_char_chips;
}

image_lookup::~image_lookup()
{
#ifdef NEVER_DEFINED

	for ( int i = 0 ; i < this->sizeof_image_t ; ++i )
	{
		if ( this->images[ i ].get_handle() != -1 )
		{
			DxLib::DeleteGraph( this->images[ i ].get_handle() );
		}
	}

	int* handle = nullptr;
	int n_chips = -1;

	for ( int i = 0 ; i < this->sizeof_sprite_t ; ++i )
	{
		handle = this->sprites[ i ].get_handle();

		if ( handle != nullptr )
		{
			n_chips = this->sprites[ i ].get_n_chips();

			for ( int j = 0 ; j < n_chips ; ++j )
			{
				DxLib::DeleteGraph( handle[ j ] );
			}
		}
	}

#endif // NEVER_DEFINED
}
