// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef IMAGE_HPP
#define IMAGE_HPP

#include "common/util.hpp"

class image
{
public:
	image();
	image( int handle, int width, int height );
	virtual ~image();

	void init( int handle, int width, int height );

	void draw( int x, int y, bool trans_flag );
	void draw( point p, bool trans_flag );
	void draw( bool trans_flag );

	int  get_handle() { return this->handle ; }
	int  get_width () { return this->width  ; }
	int  get_height() { return this->height ; }
	bool is_managed() { return this->managed; }

	void set_handle ( int  handle  ) { this->handle  = handle ; }
	void set_width  ( int  width   ) { this->width   = width  ; }
	void set_height ( int  height  ) { this->height  = height ; }
	void set_managed( bool managed ) { this->managed = managed; }

private:
	int handle;
	int width ;
	int height;

	bool managed;
};

#endif // IMAGE_HPP
