// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef GENERAL_QUEUE_HPP
#define GENERAL_QUEUE_HPP

#include <list>

template< typename T, typename Container = std::list< T > >
class general_queue
{
public:
	general_queue() {}
	virtual ~general_queue() {}

	typedef typename Container::value_type      value_type     ;
	typedef typename Container::reference       reference      ;
	typedef typename Container::const_reference const_reference;
	typedef typename Container::iterator        iterator       ;
	typedef typename Container::const_iterator  const_iterator ;
	typedef typename Container::size_type       size_type      ;
	typedef typename Container::difference_type difference_type;
	typedef          Container                  container_type ;

	bool      empty() const { return this->c.empty(); }
	size_type size () const { return this->c.size() ; }

	reference       front()       { return this->c.front(); }
	const_reference front() const { return this->c.front(); }

	reference       back()       { return this->c.back(); }
	const_reference back() const { return this->c.back(); }

	void push( const value_type& x ) { this->c.push_back( x ); }
	void pop ()                      { this->c.pop_front()   ; }

	iterator       begin()       { return this->c.begin(); }
	const_iterator begin() const { return this->c.begin(); }

	iterator       end()       { return this->c.end(); }
	const_iterator end() const { return this->c.end(); }

	void rotate();
	bool includes( const value_type& x ) const;

protected:
	Container c;
};

template< typename T, typename Container >
void general_queue< T, Container >::rotate()
{
	this->c.push_back( this->c.front() );
	this->c.pop_front();
}

template< typename T, typename Container >
bool general_queue< T, Container >::includes( const value_type& x ) const
{
	for ( iterator i = this->c.begin() ; i != this->c.end() ; ++i )
	{
		if ( *i == x )
		{
			return true;
		}
	}
	return false;
}

#endif // GENERAL_QUEUE_HPP
