// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef PARTY_BTL_HPP
#define PARTY_BTL_HPP

class battle_joiner;
#include <cstddef>

class party_btl
{
public:
	typedef battle_joiner**        iterator;
	typedef battle_joiner* const * const_iterator;
	typedef std::size_t            size_type;
	typedef std::ptrdiff_t         difference_type;

	party_btl();
	party_btl( battle_joiner* members[], std::size_t size );
	virtual ~party_btl();

	void init( battle_joiner* members[], std::size_t size );

	iterator       begin()       { return this->current_members; }
	const_iterator begin() const { return this->current_members; }
	iterator       end  ()       { return this->current_members + this->current_size; }
	const_iterator end  () const { return this->current_members + this->current_size; }
	size_type      size () const { return this->current_size; }

	int            get_ordering( battle_joiner* member   );
	battle_joiner* get_member  ( std::size_t    ordering );

protected:
	enum { capacity = 8 };

	std::size_t current_size;
	std::size_t initial_size;

	battle_joiner* current_members[ capacity ];
	battle_joiner* initial_members[ capacity ];
};

#endif // PARTY_BTL_HPP
