// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef HERO_PARTY_BTL_HPP
#define HERO_PARTY_BTL_HPP

#include "battle/party_btl.hpp"
class hero_btl;
#include <cstddef>
class battle_joiner;
#include "common/character_id.hpp"

class hero_party_btl : public party_btl
{
public:
	typedef hero_btl**        iterator;
	typedef hero_btl* const * const_iterator;

	hero_party_btl();
	hero_party_btl( battle_joiner* members[], std::size_t size );
	virtual ~hero_party_btl();

	iterator       begin()       { return this->current_heroes; }
	const_iterator begin() const { return this->current_heroes; }
	iterator       end  ()       { return this->current_heroes + this->party_btl::current_size; }
	const_iterator end  () const { return this->current_heroes + this->party_btl::current_size; }

	int                  get_ordering( character_id::hero_t hero_id  );
	character_id::hero_t get_hero_id ( std::size_t          ordering );

private:
	hero_btl** current_heroes;
	hero_btl** initial_heroes;
};

#endif // HERO_PARTY_BTL_HPP
