// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/hero_party_btl.hpp"
#include "battle/party_btl.hpp"
class hero_btl;
#include <cassert>
#include "battle/battle_joiner.hpp"
#include <cstddef>
#include "common/character_id.hpp"

hero_party_btl::hero_party_btl()
	: party_btl(),
	  current_heroes( nullptr ),
	  initial_heroes( nullptr )
{
	assert( sizeof( hero_btl* ) == sizeof( battle_joiner* ) );

	this->current_heroes = reinterpret_cast< hero_btl** >( this->party_btl::current_members );
	this->initial_heroes = reinterpret_cast< hero_btl** >( this->party_btl::initial_members );
}

hero_party_btl::hero_party_btl( battle_joiner* members[], std::size_t size )
	: party_btl( members, size ),
	  current_heroes( nullptr ),
	  initial_heroes( nullptr )
{
	assert( sizeof( hero_btl* ) == sizeof( battle_joiner* ) );

	this->current_heroes = reinterpret_cast< hero_btl** >( this->party_btl::current_members );
	this->initial_heroes = reinterpret_cast< hero_btl** >( this->party_btl::initial_members );
}

hero_party_btl::~hero_party_btl()
{
}

int hero_party_btl::get_ordering( character_id::hero_t hero_id )
{
	character_id* id = nullptr;

	for ( std::size_t i = 0 ; i < this->party_btl::current_size ; ++i )
	{
		id = this->party_btl::current_members[ i ]->get_id();

		if ( id->get_hero_id() == hero_id )
		{
			return i;
		}
	}

	return -1;
}

character_id::hero_t hero_party_btl::get_hero_id( std::size_t ordering )
{
	if ( ordering < this->party_btl::current_size )
	{
		return this->party_btl::current_members[ ordering ]->get_id()->get_hero_id();
	}
	else
	{
		return character_id::invalid_hero;
	}
}
