// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/enemy_party_window.hpp"
#include "common/util.hpp"
#include "graphics/drawable.hpp"
#include "battle/enemy_party_btl.hpp"
#include "graphics/framed_window.hpp"
#include "battle/enemy_btl.hpp"
#include "DxLib.h"

enemy_party_window::enemy_party_window( rectangle r )
	: drawable(),
	  enemy_party( nullptr ),
	  frame( r ),
	  frame_position( r.x, r.y )
{
	for ( int i = 0 ; i < this->n_enemy ; ++i )
	{
		this->enemy[ i ] = nullptr;

		this->name [ i ] = nullptr;
		this->count[ i ] = -1     ;

		this->name_position [ i ] = point( -1, -1 );
		this->count_position[ i ] = point( -1, -1 );
	}

	this->name[ 0 ] = "Su"        ;
	this->name[ 1 ] = "MKbV"  ;
	this->name[ 2 ] = "GNXfX"      ;
	this->name[ 3 ] = "Ae}EF|";

	point orig_offset (  0, 0 );
	int v_interval = 15;

	point name_offset ( 15, 6 );
	point count_offset(  0, 0 );

	point t( -1, -1 );

	for ( int i = 0 ; i < this->n_enemy ; ++i )
	{
		t.x = this->frame_position.x + orig_offset.x;
		t.y = this->frame_position.y + orig_offset.y + v_interval * i;

		this->name_position [ i ] = point( t.x + name_offset .x, t.y + name_offset .y );
		this->count_position[ i ] = point( t.x + count_offset.x, t.y + count_offset.y );
	}
}

enemy_party_window::~enemy_party_window()
{
}

void enemy_party_window::init( enemy_party_btl* enemy_party )
{
	this->enemy_party = enemy_party;
}

void enemy_party_window::draw()
{
	this->frame.draw();

	point t( -1, -1 );
	int color = DxLib::GetColor( 255, 255, 255 );

	for ( int i = 0 ; i < this->n_enemy ; ++i )
	{
		if ( this->name[ i ] != nullptr )
		{
			t.x = this->name_position[ i ].x;
			t.y = this->name_position[ i ].y;

			DxLib::SetFontSize( 10 );
			DxLib::DrawString( t.x,  t.y, this->name[ i ], color );
			DxLib::SetFontSize( 10 );
		}
	}
}
