// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/enemy_party_btl.hpp"
#include "battle/party_btl.hpp"
class enemy_btl;
#include <cassert>
#include "battle/battle_joiner.hpp"
#include <cstddef>
#include "common/character_id.hpp"

enemy_party_btl::enemy_party_btl()
	: party_btl(),
	  current_enemies( nullptr ),
	  initial_enemies( nullptr )
{
	assert( sizeof( enemy_btl* ) == sizeof( battle_joiner* ) );

	this->current_enemies = reinterpret_cast< enemy_btl** >( this->party_btl::current_members );
	this->initial_enemies = reinterpret_cast< enemy_btl** >( this->party_btl::initial_members );
}

enemy_party_btl::enemy_party_btl( battle_joiner* members[], std::size_t size )
	: party_btl( members, size ),
	  current_enemies( nullptr ),
	  initial_enemies( nullptr )
{
	assert( sizeof( enemy_btl* ) == sizeof( battle_joiner* ) );

	this->current_enemies = reinterpret_cast< enemy_btl** >( this->party_btl::current_members );
	this->initial_enemies = reinterpret_cast< enemy_btl** >( this->party_btl::initial_members );
}

enemy_party_btl::~enemy_party_btl()
{
}

int enemy_party_btl::get_ordering( character_id::enemy_t enemy_id )
{
	character_id* id = nullptr;

	for ( std::size_t i = 0 ; i < this->party_btl::current_size ; ++i )
	{
		id = this->party_btl::current_members[ i ]->get_id();

		if ( id->get_enemy_id() == enemy_id )
		{
			return i;
		}
	}

	return -1;
}

character_id::enemy_t enemy_party_btl::get_enemy_id( std::size_t ordering )
{
	if ( ordering < this->party_btl::current_size )
	{
		return this->party_btl::current_members[ ordering ]->get_id()->get_enemy_id();
	}
	else
	{
		return character_id::invalid_enemy;
	}
}
