// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/command_window.hpp"
#include "common/util.hpp"
#include "graphics/drawable.hpp"
#include "graphics/framed_window.hpp"
#include "DxLib.h"

command_window::command_window( rectangle r )
	: drawable(),
	  frame( r ),
	  frame_position( r.x, r.y ),
	  command_name_offset( 15, 6 ),
	  command_name_interval( 0, 15 )
{
	for ( int i = 0 ; i < this->n_command ; ++i )
	{
		this->command_name[ i ] = nullptr;
	}

	this->command_name[ 0 ] = ""  ;
	this->command_name[ 1 ] = "܂ق";
	this->command_name[ 2 ] = "݂ꂤ";
	this->command_name[ 3 ] = "ACe"  ;

	this->load_image();
}

command_window::~command_window()
{
}

void command_window::draw()
{
	int x = this->frame_position.x;
	int y = this->frame_position.y;

	this->image_cache.draw( point( x, y ), false );
}

void command_window::load_image()
{
	rectangle r = this->frame.get_rectangle();

	int ww = r.w;
	int wh = r.h;

	// canvas ɕ`悷
	int canvas = DxLib::MakeScreen( ww, wh, FALSE );
	DxLib::SetDrawScreen( canvas );

	// `e
	this->frame.draw_();

	int x = this->command_name_offset.x;
	int y = this->command_name_offset.y;
	int color = DxLib::GetColor( 255, 255, 255 );

	for ( int i = 0 ; i < this->n_command ; ++i )
	{
		if ( this->command_name[ i ] != nullptr )
		{
			DxLib::SetFontSize( 10 );
			DxLib::DrawString( x,  y, this->command_name[ i ], color );
			DxLib::SetFontSize( 10 );
		}
		x += this->command_name_interval.x;
		y += this->command_name_interval.y;
	}

	// `ɖ߂
	DxLib::SetDrawScreen( DX_SCREEN_BACK );

	// ̎Ή
	int handle = this->image_cache.get_handle();
	if ( handle != -1 )
	{
		DxLib::DeleteGraph( handle );
	}

	this->image_cache = image( canvas, ww, wh );
}
