// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/battle_sequence.hpp"
#include "system_base/sequence.hpp"
#include "battle/atb_scheduler.hpp"
#include "battle/command_publisher.hpp"
#include "battle/battle_event_manager.hpp"
#include "battle/battle_context.hpp"

#include "battle/hero_party_btl.hpp"
#include "battle/layered_updater_btl.hpp"
#include "battle/layered_drawer_btl.hpp"
#include "battle/battle_event_manager.hpp"
#include "battle/battle_object_factory.hpp"
#include "battle/charinfo_provider.hpp"
#include "common/character_status.hpp"
#include "battle/hero_btl.hpp"
#include "common/character_id.hpp"
class battle_joiner;
#include "battle/hero_party_window.hpp"
#include "battle/enemy_party_window.hpp"
#include "battle/message_window.hpp"
#include "battle/command_window.hpp"
#include "battle/background_drawer.hpp"
#include "battle/character_graphic_btl.hpp"

battle_sequence::battle_sequence()
	: sequence(),
	  context()
{
}

battle_sequence::~battle_sequence()
{
}

void battle_sequence::initialize_battle()
{
	this->scheduler    .init( &( this->context ) );
	this->commander    .init( &( this->context ) );
	this->event_manager.init( &( this->context ) );

	// --------------------------------------------------

	battle_object_factory* factory = battle_object_factory::instance();

	character_status::battle_position front = character_status::front;
	character_status::battle_position back  = character_status::back;

	hero_btl* dino  = factory->get_hero();
	hero_btl* milia = factory->get_hero();
	hero_btl* maria = factory->get_hero();
	hero_btl* jay   = factory->get_hero();

	charinfo_provider* charinfo = charinfo_provider::instance();

	charinfo->populate_hero( dino , character_id::dino , 0, front );
	charinfo->populate_hero( milia, character_id::milia, 1, front );
	charinfo->populate_hero( maria, character_id::maria, 2, back  );
	charinfo->populate_hero( jay  , character_id::jay  , 3, back  );

	hero_party_btl* hero_party = this->context.get_hero_party();
	battle_joiner* heroes[ 4 ] = { dino, milia, maria, jay };

	charinfo->populate_hero_party( hero_party, heroes, 4 );

	layered_updater_btl* updater = this->context.get_updater();
	layered_drawer_btl*  drawer  = this->context.get_drawer ();

	updater->add_to_layer( layered_updater_btl::hero, jay   );
	updater->add_to_layer( layered_updater_btl::hero, maria );
	updater->add_to_layer( layered_updater_btl::hero, milia );
	updater->add_to_layer( layered_updater_btl::hero, dino  );

	drawer->add_to_layer( layered_drawer_btl::hero, jay  ->get_graphic() );
	drawer->add_to_layer( layered_drawer_btl::hero, maria->get_graphic() );
	drawer->add_to_layer( layered_drawer_btl::hero, milia->get_graphic() );
	drawer->add_to_layer( layered_drawer_btl::hero, dino ->get_graphic() );

	// --------------------------------------------------

	hero_party_window*  hero_window  = this->context.get_hero_window ();
	enemy_party_window* enemy_window = this->context.get_enemy_window();

	hero_window ->init( hero_party );
	enemy_window->init( nullptr );

	message_window* msg_window = this->context.get_msg_window();
	command_window* cmd_window = this->context.get_cmd_window();

	background_drawer* bg_drawer = this->context.get_bg_drawer();

	atb_gauge* gauge[ 4 ] =
	{
		dino ->get_gauge(),
		milia->get_gauge(),
		maria->get_gauge(),
		jay  ->get_gauge()
	};
	hero_window->set_gauge( gauge );

	drawer->add_to_layer( layered_drawer_btl::window_5, hero_window  );
	drawer->add_to_layer( layered_drawer_btl::window_5, enemy_window );

	drawer->add_to_layer( layered_drawer_btl::window_4, msg_window   );
	//drawer->add_to_layer( layered_drawer_btl::window_4, cmd_window   );

	drawer->add_to_layer( layered_drawer_btl::background , bg_drawer    );
}

void battle_sequence::finalize_battle()
{
}

bool battle_sequence::update()
{
	layered_updater_btl* updater = this->context.get_updater();
	updater->update();

	return true;
}

void battle_sequence::draw()
{
	layered_drawer_btl* drawer = this->context.get_drawer();
	drawer->draw();
}
