// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef BATTLE_JOINER_HPP
#define BATTLE_JOINER_HPP

#include "common/updatable.hpp"
#include "common/character_status.hpp"
#include "common/character_id.hpp"
#include "battle/character_graphic_btl.hpp"
#include "battle/atb_gauge.hpp"
#include <memory>

class battle_joiner : public updatable
{
public:
	battle_joiner( character_status* status, character_status* init_status );
	battle_joiner( character_id* id, character_status* status, character_status* init_status, character_graphic_btl* graphic, atb_gauge* gauge );
	virtual ~battle_joiner();

	virtual bool update();

	character_id*          get_id         () { return &( this->id      )     ; }
	character_status*      get_status     () { return this->status     .get(); }
	character_status*      get_init_status() { return this->init_status.get(); }
	character_graphic_btl* get_graphic    () { return &( this->graphic )     ; }
	atb_gauge*             get_gauge      () { return &( this->gauge   )     ; }

	void set_id         ( character_id*          id          ) { this->id               = *id         ; }
	void set_status     ( character_status*      status      ) { *( this->status      ) = *status     ; }
	void set_init_status( character_status*      init_status ) { *( this->init_status ) = *init_status; }
	void set_graphic    ( character_graphic_btl* graphic     ) { this->graphic          = *graphic    ; }
	void set_gauge      ( atb_gauge*             gauge       ) { this->gauge            = *gauge      ; }

protected:
	character_id                        id         ;
	std::unique_ptr< character_status > status     ;
	std::unique_ptr< character_status > init_status;
	character_graphic_btl               graphic    ;
	atb_gauge                           gauge      ;
};

#endif // BATTLE_JOINER_HPP
