// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef BATTLE_EVENT_PRIMITIVE_HPP
#define BATTLE_EVENT_PRIMITIVE_HPP

class battle_event_primitive
{
public:
	enum primitive_t
	{
		walk_forward,
		walk_backward,
		physical_attack,
		magic_attack
	};

	battle_event_primitive( int maximum_count,
	                        void ( *event_specific_update_function )( battle_event_primitive*, int ),
	                        void ( *event_specific_draw_function )( battle_event_primitive*, int ) );
	virtual ~battle_event_primitive();

	virtual void update();
	virtual void draw();

	virtual bool has_finished();

	virtual void event_specific_update_method();
	virtual void event_specific_draw_method();

protected:
	int frame_count;
	int maximum_count;

	void ( *event_specific_update_function )( battle_event_primitive*, int );
	void ( *event_specific_draw_function )( battle_event_primitive*, int );
};

#endif // BATTLE_EVENT_PRIMITIVE_HPP
