// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/battle_event_primitive.hpp"

battle_event_primitive::battle_event_primitive( int maximum_count,
                                                void ( *event_specific_update_function )( battle_event_primitive*, int ),
                                                void ( *event_specific_draw_function )( battle_event_primitive*, int ) )
	: frame_count( 0 ),
	  maximum_count( maximum_count ),
	  event_specific_update_function( event_specific_update_function ),
	  event_specific_draw_function( event_specific_draw_function )
{
}

battle_event_primitive::~battle_event_primitive()
{
}

void battle_event_primitive::update()
{
	this->frame_count++;

	if ( this->frame_count <= this->maximum_count )
	{
		if ( this->event_specific_update_function == nullptr )
		{
			this->event_specific_update_method();
		}
		else
		{
			this->event_specific_update_function( this, this->frame_count );
		}
	}
}

void battle_event_primitive::draw()
{
	if ( this->frame_count <= this->maximum_count )
	{
		if ( this->event_specific_draw_function == nullptr )
		{
			this->event_specific_draw_method();
		}
		else
		{
			this->event_specific_draw_function( this, this->frame_count );
		}
	}
}

bool battle_event_primitive::has_finished()
{
	return ( this->frame_count < this->maximum_count ) ? false : true;
}

void battle_event_primitive::event_specific_update_method()
{
}

void battle_event_primitive::event_specific_draw_method()
{
}
