package com.torn.table;


public class Table {
	private int size;
	private Mark[][] table; /* table[x][y] */
	
	public Table(int size) {
		this.size = size;
		table = new Mark[size][size];
		for (int x = 0; x < size; x ++) {
			for (int y = 0; y < size; y ++) {
				table[x][y] = Mark.EMPTY;
			}
		}
		
	}
	public Table() {
		this(3);
	}
	
	/* TCY擾͕Kv */
	/* TODO:ϐύX */
	public int size() {
		return size;
	}
	
	public Mark get(int x, int y) {
		if (x < 0 || x >= size || y < 0 || y >= size) {
			return Mark.ERROR;
		}
		
		return table[x][y];
	}
	
	/* zu */
	public boolean put(Mark mark, int x, int y) {
		if (x < 0 || x >= size || y < 0 || y >= size) {
			return false;
		}
		if (Mark.EMPTY != table[x][y]) {
			return false;
		}
		table[x][y] = mark;
		return true;
	}
	
	/* I */
	public Mark isFinished() {
		Mark checkMark;
		int x, y;
		
		/* ɑĂ邩 */
		for (x = 0; x < size; x ++) {
			checkMark = null;
			for (y = 0; y < size; y ++) {
				if (null == checkMark && Mark.EMPTY != table[x][y]) {
					checkMark = table[x][y];
				} else if (checkMark != table[x][y]) {
					break;
				}
			}
			if (size == y) {
				return checkMark;
			}
		}
		/* cɑĂ邩 */
		for (y = 0; y < size; y ++) {
			checkMark = null;
			for (x = 0; x < size; x ++) {
				if (null == checkMark && Mark.EMPTY != table[x][y]) {
					checkMark = table[x][y];
				} else if (checkMark != table[x][y]) {
					break;
				}
			}
			if (size == x) {
				return checkMark;
			}
		}
		/* ΂߂ɑĂ邩(E) */
		checkMark = null;
		for (x = 0, y = 0; x < size; x ++, y ++) {
			if (null == checkMark && Mark.EMPTY != table[x][y]) {
				checkMark = table[x][y];
			} else if (checkMark != table[x][y]) {
				break;
			}
		}
		if (size == x) {
			return checkMark;
		}
		/* ΂߂ɑĂ邩() */
		checkMark = null;
		for (x = size-1, y = 0; y < size; x --, y ++) {
			if (null == checkMark && Mark.EMPTY != table[x][y]) {
				checkMark = table[x][y];
			} else if (checkMark != table[x][y]) {
				break;
			}
		}
		if (size == y) {
			return checkMark;
		}
		
		if (isFill()) {
			return Mark.EMPTY;
		}
		
		return null;
	}

	public boolean isFill() {
		for (int x = 0; x < size; x ++) {
			for (int y = 0; y < size; y ++) {
				if (Mark.EMPTY == table[x][y]) {
					return false;
				}
			}
		}
		return true;
	}
}
